"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
var _react = _interopRequireWildcard(require("react"));
var _button = require("../button");
var _card = require("./card");
var _icon = require("../icon");
var _flex = require("../flex");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; } /*
                                                                       * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                       * or more contributor license agreements. Licensed under the Elastic License
                                                                       * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                       * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                       * Side Public License, v 1.
                                                                       */ /// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />
var Card = function Card() {
  var _useState = (0, _react.useState)(false),
    _useState2 = _slicedToArray(_useState, 2),
    card1Selected = _useState2[0],
    setCard1 = _useState2[1];
  var _useState3 = (0, _react.useState)(false),
    _useState4 = _slicedToArray(_useState3, 2),
    card2Selected = _useState4[0],
    setCard2 = _useState4[1];
  var _useState5 = (0, _react.useState)(false),
    _useState6 = _slicedToArray(_useState5, 2),
    card3Selected = _useState6[0],
    setCard3 = _useState6[1];
  var card1Clicked = function card1Clicked() {
    setCard1(!card1Selected);
  };
  var card2Clicked = function card2Clicked() {
    setCard2(!card2Selected);
  };
  var card3Clicked = function card3Clicked() {
    setCard3(!card3Selected);
  };
  var detailsClicked = function detailsClicked(e) {
    e.stopPropagation();
  };
  return (0, _react2.jsx)(_flex.EuiFlexGroup, {
    gutterSize: "l"
  }, (0, _react2.jsx)(_flex.EuiFlexItem, null, (0, _react2.jsx)(_card.EuiCard, {
    icon: (0, _react2.jsx)(_icon.EuiIcon, {
      size: "xxl",
      type: "logoSketch"
    }),
    title: "Sketch",
    description: "Example of a short card description.",
    footer: (0, _react2.jsx)(_button.EuiButtonEmpty, {
      iconType: "iInCircle",
      size: "xs",
      onClick: detailsClicked,
      "aria-label": "See more details about Sketch"
    }, "More details"),
    selectable: {
      onClick: card1Clicked,
      isSelected: card1Selected
    }
  })), (0, _react2.jsx)(_flex.EuiFlexItem, null, (0, _react2.jsx)(_card.EuiCard, {
    icon: (0, _react2.jsx)(_icon.EuiIcon, {
      size: "xxl",
      type: "logoGCP"
    }),
    title: "Google",
    description: "Example of a longer card description. See how the footers stay lined up.",
    footer: (0, _react2.jsx)(_button.EuiButtonEmpty, {
      iconType: "iInCircle",
      size: "xs",
      onClick: detailsClicked,
      "aria-label": "See more details about Google"
    }, "More details"),
    selectable: {
      onClick: card2Clicked,
      isSelected: card2Selected
    }
  })), (0, _react2.jsx)(_flex.EuiFlexItem, null, (0, _react2.jsx)(_card.EuiCard, {
    icon: (0, _react2.jsx)(_icon.EuiIcon, {
      size: "xxl",
      type: "logoAerospike"
    }),
    title: "Not Adobe",
    description: "Example of a short card description.",
    footer: (0, _react2.jsx)(_button.EuiButtonEmpty, {
      iconType: "iInCircle",
      size: "xs",
      onClick: detailsClicked,
      "aria-label": "See more details about Not Adobe"
    }, "More details"),
    selectable: {
      onClick: card3Clicked,
      isSelected: card3Selected
    }
  })));
};
beforeEach(function () {
  cy.viewport(1024, 768); // medium breakpoint
  cy.realMount((0, _react2.jsx)(Card, null));
});
describe('EuiCard', function () {
  describe('Automated accessibility check', function () {
    it('has zero violations on first render', function () {
      cy.checkAxe();
    });
    it('has zero violations after clicking buttons', function () {
      cy.get('button[aria-checked="false"]').each(function ($el) {
        cy.wrap($el).click();
      });
      cy.checkAxe();
    });
    it('has zero violations after keyboard interaction', function () {
      cy.repeatRealPress('Tab');
      cy.realPress('Enter');
      cy.focused().should('have.attr', 'aria-checked', 'true');
      cy.repeatRealPress('Tab');
      cy.realPress('Enter');
      cy.focused().should('have.attr', 'aria-checked', 'true');
      cy.repeatRealPress('Tab');
      cy.realPress('Enter');
      cy.focused().should('have.attr', 'aria-checked', 'true');
      cy.checkAxe();
      cy.realPress('Enter');
      cy.focused().should('have.attr', 'aria-checked', 'false');
      cy.repeatRealPress(['Shift', 'Tab']);
      cy.realPress('Enter');
      cy.focused().should('have.attr', 'aria-checked', 'false');
      cy.repeatRealPress(['Shift', 'Tab']);
      cy.realPress('Enter');
      cy.focused().should('have.attr', 'aria-checked', 'false');
      cy.checkAxe();
    });
  });
});