"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiBreadcrumbContent = exports.EuiBreadcrumbCollapsed = exports.EuiBreadcrumb = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _inner_text = require("../inner_text");
var _text = require("../text");
var _link = require("../link");
var _popover = require("../popover");
var _icon = require("../icon");
var _i18n = require("../i18n");
var _breadcrumb = require("./breadcrumb.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "type", "truncate"],
  _excluded2 = ["text", "truncate", "type", "href", "rel", "onClick", "popoverContent", "popoverProps", "className", "color", "isFirstBreadcrumb", "isLastBreadcrumb", "isOnlyBreadcrumb", "highlightLastBreadcrumb", "truncateLastBreadcrumb"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
// Used internally only by the parent EuiBreadcrumbs
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var EuiBreadcrumb = function EuiBreadcrumb(_ref) {
  var children = _ref.children,
    className = _ref.className,
    type = _ref.type,
    truncate = _ref.truncate,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = (0, _classnames.default)('euiBreadcrumb', className);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _breadcrumb.euiBreadcrumbStyles)(euiTheme);
  var cssStyles = [styles.euiBreadcrumb, styles[type], truncate && styles.isTruncated];
  return (0, _react2.jsx)("li", _extends({
    className: classes,
    css: cssStyles,
    "data-test-subj": "euiBreadcrumb"
  }, rest), children);
};
exports.EuiBreadcrumb = EuiBreadcrumb;
EuiBreadcrumb.propTypes = {
  type: _propTypes.default.oneOf(["page", "application"]).isRequired,
  isFirstBreadcrumb: _propTypes.default.bool,
  isLastBreadcrumb: _propTypes.default.bool,
  isOnlyBreadcrumb: _propTypes.default.bool,
  highlightLastBreadcrumb: _propTypes.default.bool,
  truncateLastBreadcrumb: _propTypes.default.bool
};
var EuiBreadcrumbContent = function EuiBreadcrumbContent(_ref2) {
  var text = _ref2.text,
    truncate = _ref2.truncate,
    type = _ref2.type,
    href = _ref2.href,
    rel = _ref2.rel,
    onClick = _ref2.onClick,
    popoverContent = _ref2.popoverContent,
    popoverProps = _ref2.popoverProps,
    className = _ref2.className,
    color = _ref2.color,
    isFirstBreadcrumb = _ref2.isFirstBreadcrumb,
    isLastBreadcrumb = _ref2.isLastBreadcrumb,
    isOnlyBreadcrumb = _ref2.isOnlyBreadcrumb,
    highlightLastBreadcrumb = _ref2.highlightLastBreadcrumb,
    truncateLastBreadcrumb = _ref2.truncateLastBreadcrumb,
    rest = _objectWithoutProperties(_ref2, _excluded2);
  var classes = (0, _classnames.default)('euiBreadcrumb__content', className);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _breadcrumb.euiBreadcrumbContentStyles)(euiTheme);
  var cssStyles = [styles.euiBreadcrumb__content, styles[type], truncate && !truncateLastBreadcrumb && styles.isTruncated, truncateLastBreadcrumb && styles.isTruncatedLast];
  if (type === 'application') {
    if (isOnlyBreadcrumb) {
      cssStyles.push(styles.applicationStyles.onlyChild);
    } else if (isFirstBreadcrumb) {
      cssStyles.push(styles.applicationStyles.firstChild);
    } else if (isLastBreadcrumb) {
      cssStyles.push(styles.applicationStyles.lastChild);
    }
  }
  var isInteractiveBreadcrumb = href || onClick;
  var linkColor = color || (highlightLastBreadcrumb ? 'text' : 'subdued');
  var plainTextColor = highlightLastBreadcrumb ? 'default' : 'subdued'; // Does not inherit `color` prop
  var ariaCurrent = highlightLastBreadcrumb ? 'page' : undefined;
  var isPopoverBreadcrumb = !!popoverContent;
  var _useState = (0, _react.useState)(false),
    _useState2 = _slicedToArray(_useState, 2),
    isPopoverOpen = _useState2[0],
    setIsPopoverOpen = _useState2[1];
  var popoverAriaLabel = (0, _i18n.useEuiI18n)('euiBreadcrumb.popoverAriaLabel', 'Clicking this button will toggle a popover dialog.');
  return (0, _react2.jsx)(_inner_text.EuiInnerText, null, function (ref, innerText) {
    var title = innerText === '' ? undefined : innerText;
    var sharedProps = {
      ref: ref,
      title: title,
      'aria-current': ariaCurrent,
      className: classes,
      css: cssStyles
    };
    if (isPopoverBreadcrumb) {
      return (0, _react2.jsx)(_popover.EuiPopover, _extends({}, popoverProps, {
        isOpen: isPopoverOpen,
        closePopover: function closePopover() {
          return setIsPopoverOpen(false);
        },
        button: (0, _react2.jsx)(_link.EuiLink, _extends({}, sharedProps, {
          color: linkColor
          // Avoid passing href and onClick - should only toggle the popover
          ,
          onClick: function onClick() {
            return setIsPopoverOpen(function (isOpen) {
              return !isOpen;
            });
          }
        }, rest), text, ' ', (0, _react2.jsx)(_icon.EuiIcon, {
          type: "arrowDown",
          size: "s",
          "aria-label": " - ".concat(popoverAriaLabel)
        }))
      }), popoverContent);
    } else if (isInteractiveBreadcrumb) {
      return (0, _react2.jsx)(_link.EuiLink, _extends({}, sharedProps, {
        color: linkColor,
        onClick: onClick,
        href: href,
        rel: rel
      }, rest), text);
    } else {
      return (0, _react2.jsx)(_text.EuiTextColor, {
        color: plainTextColor,
        cloneElement: true
      }, (0, _react2.jsx)("span", _extends({}, sharedProps, rest), text));
    }
  });
};
exports.EuiBreadcrumbContent = EuiBreadcrumbContent;
EuiBreadcrumbContent.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  href: _propTypes.default.string,
  rel: _propTypes.default.string,
  onClick: _propTypes.default.func,
  /**
       * Visible label of the breadcrumb
       */
  text: _propTypes.default.node.isRequired,
  /**
       * Force a max-width on the breadcrumb text
       */
  truncate: _propTypes.default.bool,
  /**
       * Accepts any EuiLink `color` when rendered as one (has `href`, `onClick`, or `popoverContent`)
       */
  color: _propTypes.default.any,
  /**
       * Override the existing `aria-current` which defaults to `page` for the last breadcrumb
       */
  "aria-current": _propTypes.default.any,
  /**
       * Creates a breadcrumb that toggles a popover dialog
       *
       * If passed, both `href` and `onClick` will be ignored - the breadcrumb's
       * click behavior should only trigger a popover.
       */
  popoverContent: _propTypes.default.node,
  /**
       * Allows customizing the popover if necessary. Accepts any props that
       * [EuiPopover](/#/layout/popover) accepts, except for props that control state.
       */
  popoverProps: _propTypes.default.shape({
    /**
       * Class name passed to the direct parent of the button
       */
    anchorClassName: _propTypes.default.string,
    /**
       * Alignment of the popover and arrow relative to the button
       */
    anchorPosition: _propTypes.default.any,
    /**
       * Style and position alteration for arrow-less attachment.
       * Intended for use with inputs as anchors, e.g. EuiInputPopover
       */
    attachToAnchor: _propTypes.default.bool,
    buttonRef: _propTypes.default.any,
    /**
       * Restrict the popover's position within this element
       */
    container: _propTypes.default.any,
    /**
       * CSS display type for both the popover and anchor
       */
    display: _propTypes.default.any,
    /**
       * Object of props passed to EuiFocusTrap
       */
    focusTrapProps: _propTypes.default.any,
    /**
       * Show arrow indicating to originating button
       */
    hasArrow: _propTypes.default.bool,
    /**
       * Specifies what element should initially have focus; Can be a DOM
       * node, or a selector string (which will be passed to
       * document.querySelector() to find the DOM node), or a function that
       * returns a DOM node.
       *
       * If not passed, initial focus defaults to the popover panel.
       */
    initialFocus: _propTypes.default.any,
    /**
       * Passed directly to EuiPortal for DOM positioning. Both properties are
       * required if prop is specified
       */
    insert: _propTypes.default.shape({
      sibling: _propTypes.default.any.isRequired,
      position: _propTypes.default.oneOf(["before", "after"]).isRequired
    }),
    /**
       * Traps tab focus within the popover contents
       */
    ownFocus: _propTypes.default.bool,
    /**
       * Custom class added to the EuiPanel containing the popover contents
       */
    panelClassName: _propTypes.default.string,
    /**
       * EuiPanel padding on all sides
       */
    panelPaddingSize: _propTypes.default.any,
    /**
       * Standard DOM `style` attribute. Passed to the EuiPanel
       */
    panelStyle: _propTypes.default.any,
    /**
       * Object of props passed to EuiPanel. See #EuiPopoverPanelProps
       */
    panelProps: _propTypes.default.shape({
      element: _propTypes.default.oneOf(["div"]),
      /**
         * Padding for all four sides
         */
      paddingSize: _propTypes.default.any,
      /**
         * Corner border radius
         */
      borderRadius: _propTypes.default.any,
      /**
         * When true the panel will grow in height to match `EuiFlexItem`
         */
      grow: _propTypes.default.bool,
      panelRef: _propTypes.default.any,
      /**
         * Background color of the panel;
         * Usually a lightened form of the brand colors
         */
      color: _propTypes.default.any,
      className: _propTypes.default.string,
      "aria-label": _propTypes.default.string,
      "data-test-subj": _propTypes.default.string,
      css: _propTypes.default.any
    }),
    panelRef: _propTypes.default.any,
    /**
       * Optional screen reader instructions to announce upon popover open,
       * in addition to EUI's default popover instructions for Escape on close.
       * Useful for popovers that may have additional keyboard capabilities such as
       * arrow navigation.
       */
    popoverScreenReaderText: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.node.isRequired]),
    popoverRef: _propTypes.default.any,
    /**
       * When `true`, the popover's position is re-calculated when the user
       * scrolls, this supports having fixed-position popover anchors. When nesting
       * an `EuiPopover` in a scrollable container, `repositionOnScroll` should be `true`
       */
    repositionOnScroll: _propTypes.default.bool,
    /**
       * By default, popovers will attempt to position themselves along the initial
       * axis specified. If there is not enough room either vertically or horizontally
       * however, the popover will attempt to reposition itself along the secondary
       * cross axis if there is room there instead.
       *
       * If you do not not want this repositioning to occur (and it is acceptable for
       * the popover to appear offscreen), set this to false to disable this behavior.
       *
       * @default true
       */
    repositionToCrossAxis: _propTypes.default.bool,
    /**
       * Must be set to true if using `EuiDragDropContext` within a popover,
       * otherwise your nested drag & drop will have incorrect positioning
       */
    hasDragDrop: _propTypes.default.bool,
    /**
       * By default, popover content inherits the z-index of the anchor
       * component; pass `zIndex` to override
       */
    zIndex: _propTypes.default.number,
    /**
       * Distance away from the anchor that the popover will render
       */
    offset: _propTypes.default.number,
    /**
       * Minimum distance between the popover and the bounding container;
       * Pass an array of 4 values to adjust each side differently: `[top, right, bottom, left]`
       * Default is 16
       */
    buffer: _propTypes.default.oneOfType([_propTypes.default.number.isRequired, _propTypes.default.any.isRequired]),
    /**
       * Element to pass as the child element of the arrow;
       * Use case is typically limited to an accompanying `EuiBeacon`
       */
    arrowChildren: _propTypes.default.node,
    /**
       * Provide a name to the popover panel
       */
    "aria-label": _propTypes.default.string,
    /**
       * Alternative option to `aria-label` that takes an `id`.
       * Usually takes the `id` of the popover title
       */
    "aria-labelledby": _propTypes.default.string,
    /**
       * Function callback for when the popover positon changes
       */
    onPositionChange: _propTypes.default.func,
    className: _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any
  }),
  type: _propTypes.default.oneOf(["page", "application"]).isRequired,
  isFirstBreadcrumb: _propTypes.default.bool,
  isLastBreadcrumb: _propTypes.default.bool,
  isOnlyBreadcrumb: _propTypes.default.bool,
  highlightLastBreadcrumb: _propTypes.default.bool,
  truncateLastBreadcrumb: _propTypes.default.bool
};
var EuiBreadcrumbCollapsed = function EuiBreadcrumbCollapsed(_ref3) {
  var children = _ref3.children,
    isFirstBreadcrumb = _ref3.isFirstBreadcrumb,
    type = _ref3.type;
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _breadcrumb.euiBreadcrumbStyles)(euiTheme);
  var cssStyles = [styles.isCollapsed];
  var ariaLabel = (0, _i18n.useEuiI18n)('euiBreadcrumb.collapsedBadge.ariaLabel', 'See collapsed breadcrumbs');
  return (0, _react2.jsx)(EuiBreadcrumb, {
    css: cssStyles,
    type: type
  }, (0, _react2.jsx)(EuiBreadcrumbContent, {
    popoverContent: children,
    text: (0, _react2.jsx)("span", {
      "aria-label": ariaLabel
    }, "\u2026"),
    title: ariaLabel,
    truncate: false,
    isFirstBreadcrumb: isFirstBreadcrumb,
    type: type
  }));
};
exports.EuiBreadcrumbCollapsed = EuiBreadcrumbCollapsed;
EuiBreadcrumbCollapsed.propTypes = {
  type: _propTypes.default.oneOf(["page", "application"]).isRequired,
  isFirstBreadcrumb: _propTypes.default.bool,
  isLastBreadcrumb: _propTypes.default.bool,
  isOnlyBreadcrumb: _propTypes.default.bool,
  highlightLastBreadcrumb: _propTypes.default.bool,
  truncateLastBreadcrumb: _propTypes.default.bool
};