"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTextColor = exports.getIsValidColor = exports.getColorContrast = exports.getBadgeColors = exports.euiBadgeColors = void 0;
var _chromaJs = _interopRequireDefault(require("chroma-js"));
var _services = require("../../services");
var _mixins = require("../../themes/amsterdam/global_styling/mixins");
var _utils = require("../color_picker/utils");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }
function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
                                                                                                                                                                                                                                                                                                                                                                                               * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                               * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                               * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                                                                                                                               * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                                                                                                                               * Side Public License, v 1.
                                                                                                                                                                                                                                                                                                                                                                                               */
var euiBadgeColors = function euiBadgeColors(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme,
    colorMode = euiThemeContext.colorMode;
  return {
    // Colors shared between buttons and badges
    primary: (0, _mixins.euiButtonFillColor)(euiThemeContext, 'primary'),
    success: (0, _mixins.euiButtonFillColor)(euiThemeContext, 'success'),
    warning: (0, _mixins.euiButtonFillColor)(euiThemeContext, 'warning'),
    danger: (0, _mixins.euiButtonFillColor)(euiThemeContext, 'danger'),
    accent: (0, _mixins.euiButtonFillColor)(euiThemeContext, 'accent'),
    disabled: (0, _mixins.euiButtonColor)(euiThemeContext, 'disabled'),
    // Colors unique to badges
    default: getBadgeColors(euiThemeContext, euiTheme.colors.lightShade),
    // Hollow has a border and is used for autocompleters and beta badges
    hollow: _objectSpread(_objectSpread({}, getBadgeColors(euiThemeContext, euiTheme.colors.emptyShade)), {}, {
      borderColor: colorMode === 'DARK' ? (0, _services.tint)(euiTheme.border.color, 0.15) : euiTheme.border.color
    }),
    // Colors used by beta and notification badges
    subdued: getBadgeColors(euiThemeContext, (0, _services.tint)(euiTheme.colors.lightShade, 0.3)),
    accentText: getBadgeColors(euiThemeContext, euiTheme.colors.accentText)
  };
};
exports.euiBadgeColors = euiBadgeColors;
var getBadgeColors = function getBadgeColors(euiThemeContext, backgroundColor) {
  var color = getTextColor(euiThemeContext, backgroundColor);
  return {
    backgroundColor: backgroundColor,
    color: color
  };
};
exports.getBadgeColors = getBadgeColors;
var getTextColor = function getTextColor(_ref, bgColor) {
  var euiTheme = _ref.euiTheme;
  var textColor = _services.isColorDark.apply(void 0, _toConsumableArray((0, _chromaJs.default)(bgColor).rgb())) ? euiTheme.colors.ghost : euiTheme.colors.ink;
  return textColor;
};
exports.getTextColor = getTextColor;
var getColorContrast = function getColorContrast(textColor, color) {
  return _chromaJs.default.contrast(textColor, color);
};
exports.getColorContrast = getColorContrast;
var getIsValidColor = function getIsValidColor(color) {
  return (0, _utils.chromaValid)((0, _utils.parseColor)(color || '') || '');
};
exports.getIsValidColor = getIsValidColor;