"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiBetaBadgeStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../../global_styling");
var _color_utils = require("../color_utils");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
                                                                                                                                                                                                                                                                                           * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                           * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                           * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                           * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                           * Side Public License, v 1.
                                                                                                                                                                                                                                                                                           */
var _ref = process.env.NODE_ENV === "production" ? {
  name: "l1nme7-middle",
  styles: "vertical-align:middle;label:middle;"
} : {
  name: "l1nme7-middle",
  styles: "vertical-align:middle;label:middle;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "19hexhy-baseline",
  styles: "vertical-align:baseline;label:baseline;"
} : {
  name: "19hexhy-baseline",
  styles: "vertical-align:baseline;label:baseline;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref3 = process.env.NODE_ENV === "production" ? {
  name: "pzpqqg-euiBetaBadge__icon",
  styles: "position:relative;transform:translate(0, -1px);label:euiBetaBadge__icon;"
} : {
  name: "pzpqqg-euiBetaBadge__icon",
  styles: "position:relative;transform:translate(0, -1px);label:euiBetaBadge__icon;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiBetaBadgeStyles = function euiBetaBadgeStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme,
    colorMode = euiThemeContext.colorMode;
  var badgeColors = (0, _color_utils.euiBadgeColors)(euiThemeContext);
  return {
    euiBetaBadge: /*#__PURE__*/(0, _react.css)("display:inline-block;border-radius:", euiTheme.size.l, ";cursor:default;font-weight:", euiTheme.font.weight.bold, ";text-transform:uppercase;letter-spacing:0.05em;text-align:center;", (0, _global_styling.euiTextTruncate)(), " &:focus{", (0, _global_styling.euiFocusRing)(euiThemeContext, 'outset', {
      color: colorMode === 'DARK' ? euiTheme.colors.ghost : euiTheme.colors.ink
    }), ";};label:euiBetaBadge;"),
    // Colors
    accent: /*#__PURE__*/(0, _react.css)(badgeColors.accentText, ";label:accent;"),
    subdued: /*#__PURE__*/(0, _react.css)(badgeColors.subdued, ";label:subdued;"),
    hollow: /*#__PURE__*/(0, _react.css)("color:", badgeColors.hollow.color, ";background-color:", badgeColors.hollow.backgroundColor, ";box-shadow:inset 0 0 0 ", euiTheme.border.width.thin, " ", badgeColors.hollow.borderColor, ";;label:hollow;"),
    // Font sizes
    m: /*#__PURE__*/(0, _react.css)("font-size:", (0, _global_styling.euiFontSizeFromScale)('xs', euiTheme), ";line-height:", euiTheme.size.l, ";;label:m;"),
    s: /*#__PURE__*/(0, _react.css)("font-size:0.625rem;line-height:", (0, _global_styling.mathWithUnits)(euiTheme.size.xs, function (x) {
      return x + euiTheme.base;
    }), ";;label:s;"),
    // Padding/width sizes
    badgeSizes: {
      default: {
        m: "\n        ".concat((0, _global_styling.logicalCSS)('padding-horizontal', euiTheme.size.base)),
        s: "\n        ".concat((0, _global_styling.logicalCSS)('padding-horizontal', euiTheme.size.m))
      },
      // When it's just an icon or a single letter, make the badge a circle
      circle: {
        m: "\n          ".concat((0, _global_styling.logicalCSS)('width', euiTheme.size.l), "\n        "),
        s: "\n          ".concat((0, _global_styling.logicalCSS)('width', (0, _global_styling.mathWithUnits)(euiTheme.size.xs, function (x) {
          return x + euiTheme.base;
        })), "\n        ")
      }
    },
    euiBetaBadge__icon: _ref3,
    // Alignments
    baseline: _ref2,
    middle: _ref
  };
};
exports.euiBetaBadgeStyles = euiBetaBadgeStyles;