"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SyntheticsNetworkEventsApiResponseType = void 0;
var t = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NetworkTimingsType = t.type({
  queueing: t.number,
  connect: t.number,
  total: t.number,
  send: t.number,
  blocked: t.number,
  receive: t.number,
  wait: t.number,
  dns: t.number,
  proxy: t.number,
  ssl: t.number
});
const CertificateDataType = t.partial({
  validFrom: t.string,
  validTo: t.string,
  issuer: t.string,
  subjectName: t.string
});
const NetworkEventType = t.intersection([t.type({
  timestamp: t.string,
  requestSentTime: t.number,
  loadEndTime: t.number,
  url: t.string
}), t.partial({
  certificates: CertificateDataType,
  ip: t.string,
  method: t.string,
  status: t.number,
  mimeType: t.string,
  responseHeaders: t.record(t.string, t.string),
  requestHeaders: t.record(t.string, t.string),
  timings: NetworkTimingsType,
  transferSize: t.number,
  resourceSize: t.number
})]);
const SyntheticsNetworkEventsApiResponseType = exports.SyntheticsNetworkEventsApiResponseType = t.type({
  events: t.array(NetworkEventType),
  total: t.number,
  isWaterfallSupported: t.boolean,
  hasNavigationRequest: t.boolean
});