"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SummaryType = exports.StatesIndexStatusType = exports.LocationType = exports.DateRangeType = exports.CheckGeoType = void 0;
var t = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LocationType = exports.LocationType = t.type({
  lat: t.string,
  lon: t.string
});
const CheckGeoType = exports.CheckGeoType = t.intersection([t.type({
  name: t.string
}), t.partial({
  location: LocationType
})]);
const SummaryType = exports.SummaryType = t.partial({
  up: t.number,
  down: t.number,
  geo: CheckGeoType
});
const StatesIndexStatusType = exports.StatesIndexStatusType = t.type({
  indexExists: t.boolean,
  docCount: t.number,
  indices: t.string
});
const DateRangeType = exports.DateRangeType = t.type({
  from: t.string,
  to: t.string
});