"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatusCheckParamsType = exports.StatusCheckFiltersType = exports.RangeUnitType = exports.MonitorAvailabilityType = exports.GetMonitorAvailabilityParamsType = exports.AtomicStatusCheckParamsType = void 0;
var t = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StatusCheckFiltersType = exports.StatusCheckFiltersType = t.type({
  'monitor.type': t.array(t.string),
  'observer.geo.name': t.array(t.string),
  tags: t.array(t.string),
  'url.port': t.array(t.string)
});
const AtomicStatusCheckParamsType = exports.AtomicStatusCheckParamsType = t.intersection([t.type({
  numTimes: t.number,
  timerangeCount: t.number,
  timerangeUnit: t.string
}), t.partial({
  search: t.string,
  filters: StatusCheckFiltersType,
  shouldCheckStatus: t.boolean,
  isAutoGenerated: t.boolean,
  shouldCheckAvailability: t.boolean
})]);
const StatusCheckParamsType = exports.StatusCheckParamsType = t.intersection([t.partial({
  filters: t.string,
  shouldCheckStatus: t.boolean,
  isAutoGenerated: t.boolean
}), t.type({
  locations: t.array(t.string),
  numTimes: t.number,
  timerange: t.type({
    from: t.string,
    to: t.string
  })
})]);
const RangeUnitType = exports.RangeUnitType = t.union([t.literal('s', 'Second'), t.literal('m', 'Minute'), t.literal('h', 'Hour'), t.literal('d', 'Day'), t.literal('w', 'Week'), t.literal('M', 'Month'), t.literal('y', 'Year')]);
const GetMonitorAvailabilityParamsType = exports.GetMonitorAvailabilityParamsType = t.intersection([t.type({
  range: t.number,
  rangeUnit: RangeUnitType,
  threshold: t.string
}), t.partial({
  filters: t.string
})]);
const MonitorAvailabilityType = exports.MonitorAvailabilityType = t.intersection([t.type({
  availability: GetMonitorAvailabilityParamsType,
  shouldCheckAvailability: t.boolean
}), t.partial({
  filters: StatusCheckFiltersType,
  search: t.string
})]);