"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildEventsHistogramQuery = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _constants = require("../../../../../../common/constants");
var _build_query = require("../../../../../utils/build_query");
var i18n = _interopRequireWildcard(require("./translations"));
var _helpers = require("./helpers");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const buildEventsHistogramQuery = ({
  filterQuery,
  timerange: {
    from,
    to
  },
  defaultIndex,
  stackByField = 'event.action',
  threshold,
  includeMissingData = true
}) => {
  var _queryFilterFirstClau;
  const [queryFilterFirstClause, ...queryFilterClauses] = (0, _build_query.createQueryFilterClauses)(filterQuery);
  const stackByIpField = stackByField != null && _constants.showAllOthersBucket.includes(stackByField) && stackByField.endsWith('.ip');
  const filter = [...[{
    ...queryFilterFirstClause,
    bool: {
      ...(queryFilterFirstClause.bool || {}),
      must_not: [...(((_queryFilterFirstClau = queryFilterFirstClause.bool) === null || _queryFilterFirstClau === void 0 ? void 0 : _queryFilterFirstClau.must_not) || []), ...(stackByIpField && includeMissingData ? [{
        exists: {
          field: stackByField
        }
      }] : [])]
    }
  }, ...queryFilterClauses], ...(stackByIpField && !includeMissingData ? [{
    exists: {
      field: stackByField
    }
  }] : []), {
    range: {
      '@timestamp': {
        gte: from,
        lte: to,
        format: 'strict_date_optional_time'
      }
    }
  }];
  const getHistogramAggregation = () => {
    const interval = (0, _build_query.calculateTimeSeriesInterval)(from, to);
    const histogramTimestampField = '@timestamp';
    const dateHistogram = {
      date_histogram: {
        field: histogramTimestampField,
        fixed_interval: interval,
        min_doc_count: threshold != null ? Number(threshold === null || threshold === void 0 ? void 0 : threshold.value) : 0,
        extended_bounds: {
          min: (0, _moment.default)(from).valueOf(),
          max: (0, _moment.default)(to).valueOf()
        }
      }
    };
    const missing = stackByField != null && _constants.showAllOthersBucket.includes(stackByField) ? {
      ...(includeMissingData ? stackByField !== null && stackByField !== void 0 && stackByField.endsWith('.ip') ? {
        missing: '0.0.0.0'
      } : {
        missing: i18n.ALL_OTHERS
      } : {}),
      ...(stackByField !== null && stackByField !== void 0 && stackByField.endsWith('.ip') ? {
        value_type: 'ip'
      } : {})
    } : {};
    if (threshold != null) {
      var _threshold$field;
      const query = {
        eventActionGroup: {
          terms: {
            order: {
              _count: 'desc'
            },
            size: 10
          },
          aggs: {
            events: dateHistogram
          }
        }
      };
      const baseQuery = (0, _helpers.buildThresholdTermsQuery)({
        query,
        fields: (_threshold$field = threshold.field) !== null && _threshold$field !== void 0 ? _threshold$field : [],
        stackByField,
        missing
      });
      if (threshold.cardinality != null) {
        const enrichedQuery = (0, _helpers.buildThresholdCardinalityQuery)({
          query: baseQuery,
          cardinalityField: threshold.cardinality.field[0],
          cardinalityValue: threshold.cardinality.value
        });
        return enrichedQuery;
      }
      return baseQuery;
    }
    return {
      eventActionGroup: {
        terms: {
          field: stackByField,
          ...missing,
          order: {
            _count: 'desc'
          },
          size: 10
        },
        aggs: {
          events: dateHistogram
        }
      }
    };
  };
  const dslQuery = {
    index: defaultIndex,
    allow_no_indices: true,
    ignore_unavailable: true,
    track_total_hits: true,
    body: {
      aggregations: getHistogramAggregation(),
      query: {
        bool: {
          filter
        }
      },
      size: 0
    }
  };
  return dslQuery;
};
exports.buildEventsHistogramQuery = buildEventsHistogramQuery;