"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.internalManifestSchema = exports.internalManifestEntrySchema = exports.internalManifestCreateSchema = exports.internalArtifactSchema = exports.internalArtifactRecordSchema = exports.internalArtifactCreateSchema = exports.internalArtifactCompleteSchema = exports.internalArtifactAdditionalFields = exports.body = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _common = require("../../../../common/endpoint/schema/common");
var _common2 = require("./common");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const body = exports.body = t.string; // base64

const internalArtifactRecordSchema = exports.internalArtifactRecordSchema = t.exact(t.type({
  identifier: _common.identifier,
  compressionAlgorithm: _common.compressionAlgorithm,
  encryptionAlgorithm: _common.encryptionAlgorithm,
  decodedSha256: _common.sha256,
  decodedSize: _common.size,
  encodedSha256: _common.sha256,
  encodedSize: _common.size
}));
const internalArtifactAdditionalFields = exports.internalArtifactAdditionalFields = {
  body
};
const internalArtifactSchema = exports.internalArtifactSchema = t.intersection([internalArtifactRecordSchema, t.partial(internalArtifactAdditionalFields)]);
const internalArtifactCompleteSchema = exports.internalArtifactCompleteSchema = t.intersection([internalArtifactRecordSchema, t.exact(t.type(internalArtifactAdditionalFields))]);
const internalArtifactCreateSchema = exports.internalArtifactCreateSchema = t.intersection([internalArtifactCompleteSchema, t.exact(t.type({
  created: _common2.created
}))]);
const internalManifestEntrySchema = exports.internalManifestEntrySchema = t.exact(t.type({
  policyId: t.union([_common.identifier, t.undefined]),
  artifactId: _common.identifier
}));
const internalManifestSchema = exports.internalManifestSchema = t.exact(t.type({
  artifacts: t.array(internalManifestEntrySchema),
  schemaVersion: _common.manifestSchemaVersion,
  semanticVersion: _common.semanticVersion
}));

/**
 * The Internal map of all artifacts that the ManifestManager knows about and is managing
 */

const internalManifestCreateSchema = exports.internalManifestCreateSchema = t.intersection([internalManifestSchema, t.exact(t.type({
  created: _common2.created
}))]);