"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.manifestSchema = exports.manifestEntrySchema = exports.manifestEntryDispatchSchema = exports.manifestEntryBaseSchema = exports.manifestDispatchSchema = exports.manifestBaseSchema = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _common = require("./common");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const manifestEntryBaseSchema = exports.manifestEntryBaseSchema = t.exact(t.type({
  relative_url: _common.relativeUrl,
  decoded_sha256: _common.sha256,
  decoded_size: _common.size,
  encoded_sha256: _common.sha256,
  encoded_size: _common.size,
  encryption_algorithm: _common.encryptionAlgorithm
}));
const manifestEntrySchema = exports.manifestEntrySchema = t.intersection([manifestEntryBaseSchema, t.exact(t.type({
  compression_algorithm: _common.compressionAlgorithm
}))]);
const manifestEntryDispatchSchema = exports.manifestEntryDispatchSchema = t.intersection([manifestEntryBaseSchema, t.exact(t.type({
  compression_algorithm: _common.compressionAlgorithmDispatch
}))]);
const manifestBaseSchema = exports.manifestBaseSchema = t.exact(t.type({
  manifest_version: _common.semanticVersion,
  schema_version: _common.manifestSchemaVersion
}));
const manifestSchema = exports.manifestSchema = t.intersection([manifestBaseSchema, t.exact(t.type({
  artifacts: t.record(_common.identifier, manifestEntrySchema)
}))]);
const manifestDispatchSchema = exports.manifestDispatchSchema = t.intersection([manifestBaseSchema, t.exact(t.type({
  artifacts: t.record(_common.identifier, manifestEntryDispatchSchema)
}))]);