"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.exportRulesDetailsWithExceptionsSchema = exports.exportRulesDetails = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _securitysolutionIoTsListTypes = require("@kbn/securitysolution-io-ts-list-types");
var _securitysolutionIoTsTypes = require("@kbn/securitysolution-io-ts-types");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createSchema = (requiredFields, optionalFields) => {
  return t.intersection([t.exact(t.type(requiredFields)), t.exact(t.partial(optionalFields))]);
};
const exportRulesDetails = exports.exportRulesDetails = {
  exported_count: t.number,
  exported_rules_count: t.number,
  missing_rules: t.array(t.exact(t.type({
    rule_id: _securitysolutionIoTsTypes.NonEmptyString
  }))),
  missing_rules_count: t.number
};
const exportRulesDetailsSchema = t.exact(t.type(exportRulesDetails));
// With exceptions
const exportRulesDetailsWithExceptionsSchema = exports.exportRulesDetailsWithExceptionsSchema = createSchema(exportRulesDetails, _securitysolutionIoTsListTypes.exportExceptionDetails);