"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.thresholdOrUndefined = exports.thresholdNormalizedOrUndefined = exports.thresholdNormalized = exports.thresholdFieldNormalized = exports.thresholdField = exports.thresholdCardinalityField = exports.threshold = exports.tagsOrUndefined = exports.tags = exports.success_count = exports.success = exports.status_date = exports.status_code = exports.status = exports.sort_order = exports.sort_field = exports.sortOrderOrUndefined = exports.sortFieldOrUndefined = exports.signal_status_query = exports.signal_ids = exports.saved_id = exports.savedIdOrUndefined = exports.rules_updated = exports.rules_not_updated = exports.rules_not_installed = exports.rules_installed = exports.rules_custom_installed = exports.rule_name_override = exports.rule_id = exports.ruleNameOverrideOrUndefined = exports.ruleIdOrUndefined = exports.ruleExecutionStatus = exports.referencesOrUndefined = exports.references = exports.queryOrUndefined = exports.queryFilterOrUndefined = exports.queryFilter = exports.query = exports.privilege = exports.per_page = exports.perPageOrUndefined = exports.perPage = exports.pageOrUndefined = exports.page = exports.output_index = exports.outputIndexOrUndefined = exports.outcome = exports.objects = exports.noteOrUndefined = exports.note = exports.namespaceOrUndefined = exports.namespace = exports.nameOrUndefined = exports.name = exports.metaOrUndefined = exports.meta = exports.message = exports.licenseOrUndefined = exports.license = exports.last_success_message = exports.last_success_at = exports.last_failure_message = exports.last_failure_at = exports.intervalOrUndefined = exports.interval = exports.indexType = exports.indexRecord = exports.indexOrUndefined = exports.index = exports.immutable = exports.idOrUndefined = exports.id = exports.filtersOrUndefined = exports.filters = exports.file_name = exports.fieldsOrUndefined = exports.fields = exports.false_positives = exports.falsePositivesOrUndefined = exports.exclude_export_details = exports.event_category_override = exports.eventCategoryOverrideOrUndefined = exports.enabledOrUndefined = exports.enabled = exports.descriptionOrUndefined = exports.description = exports.created_by = exports.created_at = exports.createdByOrNull = exports.conflicts = exports.bulkAction = exports.building_block_type = exports.buildingBlockTypeOrUndefined = exports.authorOrUndefined = exports.author = exports.anomaly_threshold = exports.anomalyThresholdOrUndefined = exports.alias_target_id = exports.RuleExecutionStatus = exports.BulkAction = void 0;
exports.updated_by = exports.updated_at = exports.updatedByOrNull = exports.total = exports.toOrUndefined = exports.to = exports.timestamp_override = exports.timestampOverrideOrUndefined = exports.timelines_updated = exports.timelines_not_updated = exports.timelines_not_installed = exports.timelines_installed = exports.timeline_title = exports.timeline_id = exports.timelineTitleOrUndefined = exports.timelineIdOrUndefined = void 0;
var _securitysolutionIoTsTypes = require("@kbn/securitysolution-io-ts-types");
var t = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable @typescript-eslint/naming-convention */

const author = exports.author = t.array(t.string);
const authorOrUndefined = exports.authorOrUndefined = t.union([author, t.undefined]);
const building_block_type = exports.building_block_type = t.string;
const buildingBlockTypeOrUndefined = exports.buildingBlockTypeOrUndefined = t.union([building_block_type, t.undefined]);
const description = exports.description = _securitysolutionIoTsTypes.NonEmptyString;
const descriptionOrUndefined = exports.descriptionOrUndefined = t.union([description, t.undefined]);
// outcome is a property of the saved object resolve api
// will tell us info about the rule after 8.0 migrations
const outcome = exports.outcome = t.union([t.literal('exactMatch'), t.literal('aliasMatch'), t.literal('conflict')]);
const alias_target_id = exports.alias_target_id = t.string;
const enabled = exports.enabled = t.boolean;
const enabledOrUndefined = exports.enabledOrUndefined = t.union([enabled, t.undefined]);
const event_category_override = exports.event_category_override = t.string;
const eventCategoryOverrideOrUndefined = exports.eventCategoryOverrideOrUndefined = t.union([event_category_override, t.undefined]);
const false_positives = exports.false_positives = t.array(t.string);
const falsePositivesOrUndefined = exports.falsePositivesOrUndefined = t.union([false_positives, t.undefined]);
const file_name = exports.file_name = t.string;
const exclude_export_details = exports.exclude_export_details = t.boolean;
const namespace = exports.namespace = t.string;
/**
 * TODO: Right now the filters is an "unknown", when it could more than likely
 * become the actual ESFilter as a type.
 */
const filters = exports.filters = t.array(t.unknown); // Filters are not easily type-able yet

// Filters are not easily type-able yet

const filtersOrUndefined = exports.filtersOrUndefined = t.union([filters, t.undefined]);
const immutable = exports.immutable = t.boolean;
// Note: Never make this a strict uuid, we allow the rule_id to be any string at the moment
// in case we encounter 3rd party rule systems which might be using auto incrementing numbers
// or other different things.
const rule_id = exports.rule_id = t.string;
const ruleIdOrUndefined = exports.ruleIdOrUndefined = t.union([rule_id, t.undefined]);
const id = exports.id = _securitysolutionIoTsTypes.UUID;
const idOrUndefined = exports.idOrUndefined = t.union([id, t.undefined]);
const index = exports.index = t.array(t.string);
const indexOrUndefined = exports.indexOrUndefined = t.union([index, t.undefined]);
const interval = exports.interval = t.string;
const intervalOrUndefined = exports.intervalOrUndefined = t.union([interval, t.undefined]);
const query = exports.query = t.string;
const queryOrUndefined = exports.queryOrUndefined = t.union([query, t.undefined]);
const license = exports.license = t.string;
const licenseOrUndefined = exports.licenseOrUndefined = t.union([license, t.undefined]);
const objects = exports.objects = t.array(t.type({
  rule_id
}));
const output_index = exports.output_index = t.string;
const outputIndexOrUndefined = exports.outputIndexOrUndefined = t.union([output_index, t.undefined]);
const saved_id = exports.saved_id = t.string;
const savedIdOrUndefined = exports.savedIdOrUndefined = t.union([saved_id, t.undefined]);
const timeline_id = exports.timeline_id = t.string;
const timelineIdOrUndefined = exports.timelineIdOrUndefined = t.union([timeline_id, t.undefined]);
const timeline_title = exports.timeline_title = t.string;
const timelineTitleOrUndefined = exports.timelineTitleOrUndefined = t.union([timeline_title, t.undefined]);
const timestamp_override = exports.timestamp_override = t.string;
const timestampOverrideOrUndefined = exports.timestampOverrideOrUndefined = t.union([timestamp_override, t.undefined]);
const anomaly_threshold = exports.anomaly_threshold = _securitysolutionIoTsTypes.PositiveInteger;
const anomalyThresholdOrUndefined = exports.anomalyThresholdOrUndefined = t.union([anomaly_threshold, t.undefined]);
/**
 * Note that this is a non-exact io-ts type as we allow extra meta information
 * to be added to the meta object
 */
const meta = exports.meta = t.object;
const metaOrUndefined = exports.metaOrUndefined = t.union([meta, t.undefined]);
const name = exports.name = _securitysolutionIoTsTypes.NonEmptyString;
const nameOrUndefined = exports.nameOrUndefined = t.union([name, t.undefined]);
const rule_name_override = exports.rule_name_override = t.string;
const ruleNameOverrideOrUndefined = exports.ruleNameOverrideOrUndefined = t.union([rule_name_override, t.undefined]);
const status = exports.status = t.keyof({
  open: null,
  closed: null,
  acknowledged: null,
  'in-progress': null // TODO: Remove after `acknowledged` migrations
});
let RuleExecutionStatus = exports.RuleExecutionStatus = /*#__PURE__*/function (RuleExecutionStatus) {
  RuleExecutionStatus["succeeded"] = "succeeded";
  RuleExecutionStatus["failed"] = "failed";
  RuleExecutionStatus["going to run"] = "going to run";
  RuleExecutionStatus["partial failure"] = "partial failure";
  RuleExecutionStatus["warning"] = "warning";
  return RuleExecutionStatus;
}({});
const ruleExecutionStatus = exports.ruleExecutionStatus = (0, _securitysolutionIoTsTypes.enumeration)('RuleExecutionStatus', RuleExecutionStatus);
const conflicts = exports.conflicts = t.keyof({
  abort: null,
  proceed: null
});
// TODO: Create a regular expression type or custom date math part type here
const to = exports.to = t.string;
const toOrUndefined = exports.toOrUndefined = t.union([to, t.undefined]);
const queryFilter = exports.queryFilter = t.string;
const queryFilterOrUndefined = exports.queryFilterOrUndefined = t.union([queryFilter, t.undefined]);
const references = exports.references = t.array(t.string);
const referencesOrUndefined = exports.referencesOrUndefined = t.union([references, t.undefined]);
const per_page = exports.per_page = _securitysolutionIoTsTypes.PositiveInteger;
const perPageOrUndefined = exports.perPageOrUndefined = t.union([per_page, t.undefined]);
const page = exports.page = _securitysolutionIoTsTypes.PositiveIntegerGreaterThanZero;
const pageOrUndefined = exports.pageOrUndefined = t.union([page, t.undefined]);
const signal_ids = exports.signal_ids = t.array(t.string);
// TODO: Can this be more strict or is this is the set of all Elastic Queries?
const signal_status_query = exports.signal_status_query = t.object;
const sort_field = exports.sort_field = t.string;
const sortFieldOrUndefined = exports.sortFieldOrUndefined = t.union([sort_field, t.undefined]);
const sort_order = exports.sort_order = t.keyof({
  asc: null,
  desc: null
});
const sortOrderOrUndefined = exports.sortOrderOrUndefined = t.union([sort_order, t.undefined]);
const tags = exports.tags = t.array(t.string);
const tagsOrUndefined = exports.tagsOrUndefined = t.union([tags, t.undefined]);
const fields = exports.fields = t.array(t.string);
const fieldsOrUndefined = exports.fieldsOrUndefined = t.union([fields, t.undefined]);
const thresholdField = exports.thresholdField = t.exact(t.type({
  field: t.union([t.string, t.array(t.string)]),
  // Covers pre- and post-7.12
  value: _securitysolutionIoTsTypes.PositiveIntegerGreaterThanZero
}));
const thresholdFieldNormalized = exports.thresholdFieldNormalized = t.exact(t.type({
  field: t.array(t.string),
  value: _securitysolutionIoTsTypes.PositiveIntegerGreaterThanZero
}));
const thresholdCardinalityField = exports.thresholdCardinalityField = t.exact(t.type({
  field: t.string,
  value: _securitysolutionIoTsTypes.PositiveInteger
}));
const threshold = exports.threshold = t.intersection([thresholdField, t.exact(t.partial({
  cardinality: t.array(thresholdCardinalityField)
}))]);
const thresholdOrUndefined = exports.thresholdOrUndefined = t.union([threshold, t.undefined]);
const thresholdNormalized = exports.thresholdNormalized = t.intersection([thresholdFieldNormalized, t.exact(t.partial({
  cardinality: t.array(thresholdCardinalityField)
}))]);
const thresholdNormalizedOrUndefined = exports.thresholdNormalizedOrUndefined = t.union([thresholdNormalized, t.undefined]);
const created_at = exports.created_at = _securitysolutionIoTsTypes.IsoDateString;
const updated_at = exports.updated_at = _securitysolutionIoTsTypes.IsoDateString;
const updated_by = exports.updated_by = t.string;
const created_by = exports.created_by = t.string;
const updatedByOrNull = exports.updatedByOrNull = t.union([updated_by, t.null]);
const createdByOrNull = exports.createdByOrNull = t.union([created_by, t.null]);
const last_success_at = exports.last_success_at = _securitysolutionIoTsTypes.IsoDateString;
const last_success_message = exports.last_success_message = t.string;
const last_failure_at = exports.last_failure_at = _securitysolutionIoTsTypes.IsoDateString;
const last_failure_message = exports.last_failure_message = t.string;
const status_date = exports.status_date = _securitysolutionIoTsTypes.IsoDateString;
const rules_installed = exports.rules_installed = _securitysolutionIoTsTypes.PositiveInteger;
const rules_updated = exports.rules_updated = _securitysolutionIoTsTypes.PositiveInteger;
const status_code = exports.status_code = _securitysolutionIoTsTypes.PositiveInteger;
const message = exports.message = t.string;
const perPage = exports.perPage = _securitysolutionIoTsTypes.PositiveInteger;
const total = exports.total = _securitysolutionIoTsTypes.PositiveInteger;
const success = exports.success = t.boolean;
const success_count = exports.success_count = _securitysolutionIoTsTypes.PositiveInteger;
const rules_custom_installed = exports.rules_custom_installed = _securitysolutionIoTsTypes.PositiveInteger;
const rules_not_installed = exports.rules_not_installed = _securitysolutionIoTsTypes.PositiveInteger;
const rules_not_updated = exports.rules_not_updated = _securitysolutionIoTsTypes.PositiveInteger;
const timelines_installed = exports.timelines_installed = _securitysolutionIoTsTypes.PositiveInteger;
const timelines_updated = exports.timelines_updated = _securitysolutionIoTsTypes.PositiveInteger;
const timelines_not_installed = exports.timelines_not_installed = _securitysolutionIoTsTypes.PositiveInteger;
const timelines_not_updated = exports.timelines_not_updated = _securitysolutionIoTsTypes.PositiveInteger;
const note = exports.note = t.string;
const namespaceOrUndefined = exports.namespaceOrUndefined = t.union([namespace, t.undefined]);
const noteOrUndefined = exports.noteOrUndefined = t.union([note, t.undefined]);
const indexRecord = exports.indexRecord = t.record(t.string, t.type({
  all: t.boolean,
  maintenance: t.boolean,
  manage_ilm: t.boolean,
  read: t.boolean,
  create_index: t.boolean,
  read_cross_cluster: t.boolean,
  index: t.boolean,
  monitor: t.boolean,
  delete: t.boolean,
  manage: t.boolean,
  delete_index: t.boolean,
  create_doc: t.boolean,
  view_index_metadata: t.boolean,
  create: t.boolean,
  manage_follow_index: t.boolean,
  manage_leader_index: t.boolean,
  write: t.boolean
}));
const indexType = exports.indexType = t.type({
  index: indexRecord
});
const privilege = exports.privilege = t.type({
  username: t.string,
  has_all_requested: t.boolean,
  cluster: t.type({
    monitor_ml: t.boolean,
    manage_ccr: t.boolean,
    manage_index_templates: t.boolean,
    monitor_watcher: t.boolean,
    monitor_transform: t.boolean,
    read_ilm: t.boolean,
    manage_security: t.boolean,
    manage_own_api_key: t.boolean,
    manage_saml: t.boolean,
    all: t.boolean,
    manage_ilm: t.boolean,
    manage_ingest_pipelines: t.boolean,
    read_ccr: t.boolean,
    manage_rollup: t.boolean,
    monitor: t.boolean,
    manage_watcher: t.boolean,
    manage: t.boolean,
    manage_transform: t.boolean,
    manage_token: t.boolean,
    manage_ml: t.boolean,
    manage_pipeline: t.boolean,
    monitor_rollup: t.boolean,
    transport_client: t.boolean,
    create_snapshot: t.boolean
  }),
  index: indexRecord,
  is_authenticated: t.boolean,
  has_encryption_key: t.boolean
});
let BulkAction = exports.BulkAction = /*#__PURE__*/function (BulkAction) {
  BulkAction["enable"] = "enable";
  BulkAction["disable"] = "disable";
  BulkAction["export"] = "export";
  BulkAction["delete"] = "delete";
  BulkAction["duplicate"] = "duplicate";
  return BulkAction;
}({});
const bulkAction = exports.bulkAction = (0, _securitysolutionIoTsTypes.enumeration)('BulkAction', BulkAction);