"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.runTaskFnFactory = void 0;
var _elasticApmNode = _interopRequireDefault(require("elastic-apm-node"));
var Rx = _interopRequireWildcard(require("rxjs"));
var _operators = require("rxjs/operators");
var _constants = require("../../../../common/constants");
var _common = require("../../common");
var _generate_pdf = require("../lib/generate_pdf");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const runTaskFnFactory = exports.runTaskFnFactory = function executeJobFactoryFn(reporting, parentLogger) {
  const config = reporting.getConfig();
  const encryptionKey = config.get('encryptionKey');
  return async function runTask(jobId, job, cancellationToken, stream) {
    const jobLogger = parentLogger.clone([_constants.PDF_JOB_TYPE, 'execute-job', jobId]);
    const apmTrans = _elasticApmNode.default.startTransaction('execute-job-pdf', _constants.REPORTING_TRANSACTION_TYPE);
    const apmGetAssets = apmTrans === null || apmTrans === void 0 ? void 0 : apmTrans.startSpan('get-assets', 'setup');
    let apmGeneratePdf;
    const generatePdfObservable = await (0, _generate_pdf.generatePdfObservableFactory)(reporting);
    const process$ = Rx.of(1).pipe((0, _operators.mergeMap)(() => (0, _common.decryptJobHeaders)(encryptionKey, job.headers, jobLogger)), (0, _operators.map)(decryptedHeaders => (0, _common.omitBlockedHeaders)(decryptedHeaders)), (0, _operators.map)(filteredHeaders => (0, _common.getConditionalHeaders)(config, filteredHeaders)), (0, _operators.mergeMap)(conditionalHeaders => (0, _common.getCustomLogo)(reporting, conditionalHeaders, job.spaceId, jobLogger)), (0, _operators.mergeMap)(({
      logo,
      conditionalHeaders
    }) => {
      const urls = (0, _common.getFullUrls)(config, job);
      const {
        browserTimezone,
        layout,
        title
      } = job;
      apmGetAssets === null || apmGetAssets === void 0 ? void 0 : apmGetAssets.end();
      apmGeneratePdf = apmTrans === null || apmTrans === void 0 ? void 0 : apmTrans.startSpan('generate-pdf-pipeline', 'execute');
      return generatePdfObservable(jobLogger, title, urls, browserTimezone, conditionalHeaders, layout, logo);
    }), (0, _operators.tap)(({
      buffer
    }) => {
      var _apmGeneratePdf;
      (_apmGeneratePdf = apmGeneratePdf) === null || _apmGeneratePdf === void 0 ? void 0 : _apmGeneratePdf.end();
      if (buffer) {
        stream.write(buffer);
      }
    }), (0, _operators.map)(({
      warnings
    }) => ({
      content_type: 'application/pdf',
      warnings
    })), (0, _operators.catchError)(err => {
      jobLogger.error(err);
      return Rx.throwError(err);
    }));
    const stop$ = Rx.fromEventPattern(cancellationToken.on);
    apmTrans === null || apmTrans === void 0 ? void 0 : apmTrans.end();
    return process$.pipe((0, _operators.takeUntil)(stop$)).toPromise();
  };
};