"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.safeChildProcess = safeChildProcess;
var Rx = _interopRequireWildcard(require("rxjs"));
var _operators = require("rxjs/operators");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Our process can get sent various signals, and when these occur we wish to
// kill the subprocess and then kill our process as long as the observer isn't cancelled
function safeChildProcess(logger, childProcess) {
  const ownTerminateSignal$ = Rx.merge(Rx.fromEvent(process, 'SIGTERM').pipe((0, _operators.mapTo)('SIGTERM')), Rx.fromEvent(process, 'SIGINT').pipe((0, _operators.mapTo)('SIGINT')), Rx.fromEvent(process, 'SIGBREAK').pipe((0, _operators.mapTo)('SIGBREAK'))).pipe((0, _operators.take)(1), (0, _operators.share)());
  const ownTerminateMapToKill$ = ownTerminateSignal$.pipe((0, _operators.tap)(signal => {
    logger.debug(`Kibana process received terminate signal: ${signal}`);
  }), (0, _operators.mapTo)('SIGKILL'));
  const kibanaForceExit$ = Rx.fromEvent(process, 'exit').pipe((0, _operators.take)(1), (0, _operators.tap)(signal => {
    logger.debug(`Kibana process forcefully exited with signal: ${signal}`);
  }), (0, _operators.mapTo)('SIGKILL'));
  const signalForChildProcess$ = Rx.merge(ownTerminateMapToKill$, kibanaForceExit$);
  const logAndKillChildProcess = (0, _operators.tap)(signal => {
    logger.debug(`Child process terminate signal was: ${signal}. Closing the browser...`);
    return childProcess.kill(signal);
  });

  // send termination signals
  const terminate$ = Rx.merge(signalForChildProcess$.pipe(logAndKillChildProcess), ownTerminateSignal$.pipe((0, _operators.delay)(1), (0, _operators.tap)(signal => {
    logger.debug(`Kibana process terminate signal was: ${signal}. Closing the browser...`);
    return process.kill(process.pid, signal);
  })));
  return {
    terminate$
  };
}