"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JOB_MAP_NODE_TYPES = exports.DEFAULT_RESULTS_FIELD = exports.DATA_FRAME_TASK_STATE = exports.BUILT_IN_MODEL_TAG = exports.ANALYSIS_CONFIG_TYPE = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ANALYSIS_CONFIG_TYPE = exports.ANALYSIS_CONFIG_TYPE = {
  OUTLIER_DETECTION: 'outlier_detection',
  REGRESSION: 'regression',
  CLASSIFICATION: 'classification'
};
const DATA_FRAME_TASK_STATE = exports.DATA_FRAME_TASK_STATE = {
  ANALYZING: 'analyzing',
  FAILED: 'failed',
  REINDEXING: 'reindexing',
  STARTED: 'started',
  STARTING: 'starting',
  STOPPED: 'stopped'
};
const DEFAULT_RESULTS_FIELD = exports.DEFAULT_RESULTS_FIELD = 'ml';
const JOB_MAP_NODE_TYPES = exports.JOB_MAP_NODE_TYPES = {
  ANALYTICS: 'analytics',
  TRANSFORM: 'transform',
  INDEX: 'index',
  TRAINED_MODEL: 'trainedModel'
};
const BUILT_IN_MODEL_TAG = exports.BUILT_IN_MODEL_TAG = 'prepackaged';