"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDatatable = void 0;
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
} /*
  * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
  * or more contributor license agreements. Licensed under the Elastic License
  * 2.0; you may not use this file except in compliance with the Elastic License
  * 2.0.
  */
const getDatatable = getFormatFactory => ({
  name: 'lens_datatable',
  type: 'render',
  inputTypes: ['lens_multitable'],
  help: _i18n.i18n.translate('xpack.lens.datatable.expressionHelpLabel', {
    defaultMessage: 'Datatable renderer'
  }),
  args: {
    title: {
      types: ['string'],
      help: _i18n.i18n.translate('xpack.lens.datatable.titleLabel', {
        defaultMessage: 'Title'
      })
    },
    description: {
      types: ['string'],
      help: ''
    },
    columns: {
      types: ['lens_datatable_column'],
      help: '',
      multi: true
    },
    sortingColumnId: {
      types: ['string'],
      help: ''
    },
    sortingDirection: {
      types: ['string'],
      help: ''
    }
  },
  async fn(...args) {
    /** Build optimization: prevent adding extra code into initial bundle **/
    const {
      datatableFn
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./datatable_fn')));
    return datatableFn(getFormatFactory)(...args);
  }
});
exports.getDatatable = getDatatable;