"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopMetricsTypeRT = exports.TermsWithMetrics = exports.PercentilesTypeRT = exports.PercentilesKeyedTypeRT = exports.NormalizedMetricValueRT = exports.MetricValueTypeRT = exports.HistogramResponseRT = exports.HistogramBucketRT = exports.GroupingResponseRT = exports.BasicMetricValueRT = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NumberOrNullRT = rt.union([rt.number, rt.null]);
const BasicMetricValueRT = exports.BasicMetricValueRT = rt.type({
  value: NumberOrNullRT
});
const NormalizedMetricValueRT = exports.NormalizedMetricValueRT = rt.intersection([BasicMetricValueRT, rt.type({
  normalized_value: NumberOrNullRT
})]);
const PercentilesTypeRT = exports.PercentilesTypeRT = rt.type({
  values: rt.record(rt.string, NumberOrNullRT)
});
const PercentilesKeyedTypeRT = exports.PercentilesKeyedTypeRT = rt.type({
  values: rt.array(rt.type({
    key: rt.string,
    value: NumberOrNullRT
  }))
});
const TopMetricsTypeRT = exports.TopMetricsTypeRT = rt.type({
  top: rt.array(rt.type({
    sort: rt.union([rt.array(rt.number), rt.array(rt.string)]),
    metrics: rt.record(rt.string, rt.union([rt.number, rt.string, rt.null]))
  }))
});
const MetricValueTypeRT = exports.MetricValueTypeRT = rt.union([BasicMetricValueRT, NormalizedMetricValueRT, PercentilesTypeRT, PercentilesKeyedTypeRT, TopMetricsTypeRT]);
const TermsWithMetrics = exports.TermsWithMetrics = rt.intersection([rt.type({
  buckets: rt.array(rt.record(rt.string, rt.union([rt.number, rt.string, MetricValueTypeRT])))
}), rt.partial({
  sum_other_doc_count: rt.number,
  doc_count_error_upper_bound: rt.number
})]);
const HistogramBucketRT = exports.HistogramBucketRT = rt.record(rt.string, rt.union([rt.number, rt.string, MetricValueTypeRT, TermsWithMetrics]));
const HistogramResponseRT = exports.HistogramResponseRT = rt.type({
  histogram: rt.type({
    buckets: rt.array(HistogramBucketRT)
  }),
  metricsets: rt.type({
    buckets: rt.array(rt.type({
      key: rt.string,
      doc_count: rt.number
    }))
  })
});
const GroupingBucketRT = rt.intersection([rt.type({
  key: rt.record(rt.string, rt.string),
  doc_count: rt.number
}), HistogramResponseRT]);
const GroupingResponseRT = exports.GroupingResponseRT = rt.type({
  groupings: rt.intersection([rt.type({
    buckets: rt.array(GroupingBucketRT)
  }), rt.partial({
    after_key: rt.record(rt.string, rt.string)
  })])
});