"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.logEntryDatasetsResponseRT = exports.createLogEntryDatasetsQuery = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _elasticsearch_runtime_types = require("../../../../utils/elasticsearch_runtime_types");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createLogEntryDatasetsQuery = (indexName, timestampField, startTime, endTime, runtimeMappings, size, afterKey) => ({
  ...defaultRequestParameters,
  body: {
    query: {
      bool: {
        filter: [{
          range: {
            [timestampField]: {
              gte: startTime,
              lte: endTime
            }
          }
        }, {
          exists: {
            field: 'event.dataset'
          }
        }]
      }
    },
    runtime_mappings: runtimeMappings,
    aggs: {
      dataset_buckets: {
        composite: {
          after: afterKey,
          size,
          sources: [{
            dataset: {
              terms: {
                field: 'event.dataset',
                order: 'asc'
              }
            }
          }]
        }
      }
    }
  },
  index: indexName,
  size: 0
});
exports.createLogEntryDatasetsQuery = createLogEntryDatasetsQuery;
const defaultRequestParameters = {
  allow_no_indices: true,
  ignore_unavailable: true,
  track_scores: false,
  track_total_hits: false
};
const compositeDatasetKeyRT = rt.type({
  dataset: rt.string
});
const logEntryDatasetBucketRT = rt.type({
  key: compositeDatasetKeyRT
});
const logEntryDatasetsResponseRT = exports.logEntryDatasetsResponseRT = rt.intersection([_elasticsearch_runtime_types.commonSearchSuccessResponseFieldsRT, rt.type({
  aggregations: rt.type({
    dataset_buckets: rt.intersection([rt.type({
      buckets: rt.array(logEntryDatasetBucketRT)
    }), rt.partial({
      after_key: compositeDatasetKeyRT
    })])
  })
})]);