"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createMetricThresholdExecutor = exports.WARNING_ACTIONS = exports.FIRED_ACTIONS = void 0;
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _common = require("../../../../../alerting/common");
var _messages = require("../common/messages");
var _utils = require("../common/utils");
var _formatters = require("../../../../common/formatters");
var _types = require("./types");
var _evaluate_alert = require("./lib/evaluate_alert");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
} /*
  * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
  * or more contributor license agreements. Licensed under the Elastic License
  * 2.0; you may not use this file except in compliance with the Elastic License
  * 2.0.
  */
// no specific instace state used
// no specific instace state used

const createMetricThresholdExecutor = libs => libs.metricsRules.createLifecycleRuleExecutor(async function (options) {
  var _state$groups$filter, _state$groups;
  const {
    services,
    params,
    state
  } = options;
  const {
    criteria
  } = params;
  if (criteria.length === 0) throw new Error('Cannot execute an alert with 0 conditions');
  const {
    alertWithLifecycle,
    savedObjectsClient
  } = services;
  const alertInstanceFactory = (id, reason) => alertWithLifecycle({
    id,
    fields: {
      [_ruleDataUtils.ALERT_REASON]: reason
    }
  });
  const {
    sourceId,
    alertOnNoData,
    alertOnGroupDisappear: _alertOnGroupDisappear
  } = params;
  if (!params.filterQuery && params.filterQueryText) {
    try {
      const {
        fromKueryExpression
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/es-query')));
      fromKueryExpression(params.filterQueryText);
    } catch (e) {
      const timestamp = (0, _moment.default)().toISOString();
      const actionGroupId = FIRED_ACTIONS.id; // Change this to an Error action group when able
      const reason = (0, _messages.buildInvalidQueryAlertReason)(params.filterQueryText);
      const alertInstance = alertInstanceFactory(_utils.UNGROUPED_FACTORY_KEY, reason);
      alertInstance.scheduleActions(actionGroupId, {
        group: _utils.UNGROUPED_FACTORY_KEY,
        alertState: _messages.stateToAlertMessage[_types.AlertStates.ERROR],
        reason,
        timestamp,
        value: null,
        metric: mapToConditionsLookup(criteria, c => c.metric)
      });
      return {
        groups: [],
        groupBy: params.groupBy,
        filterQuery: params.filterQuery
      };
    }
  }

  // For backwards-compatibility, interpret undefined alertOnGroupDisappear as true
  const alertOnGroupDisappear = _alertOnGroupDisappear !== false;
  const source = await libs.sources.getSourceConfiguration(savedObjectsClient, sourceId || 'default');
  const config = source.configuration;
  const previousGroupBy = state.groupBy;
  const previousFilterQuery = state.filterQuery;
  const prevGroups = alertOnGroupDisappear && (0, _lodash.isEqual)(previousGroupBy, params.groupBy) && (0, _lodash.isEqual)(previousFilterQuery, params.filterQuery) ?
  // Filter out the * key from the previous groups, only include it if it's one of
  // the current groups. In case of a groupBy alert that starts out with no data and no
  // groups, we don't want to persist the existence of the * alert instance
  (_state$groups$filter = (_state$groups = state.groups) === null || _state$groups === void 0 ? void 0 : _state$groups.filter(g => g !== _utils.UNGROUPED_FACTORY_KEY)) !== null && _state$groups$filter !== void 0 ? _state$groups$filter : [] : [];
  const alertResults = await (0, _evaluate_alert.evaluateAlert)(services.scopedClusterClient.asCurrentUser, params, config, prevGroups);

  // Because each alert result has the same group definitions, just grab the groups from the first one.
  const resultGroups = Object.keys((0, _lodash.first)(alertResults));
  // Merge the list of currently fetched groups and previous groups, and uniquify them. This is necessary for reporting
  // no data results on groups that get removed
  const groups = [...new Set([...prevGroups, ...resultGroups])];
  const hasGroups = !(0, _lodash.isEqual)(groups, [_utils.UNGROUPED_FACTORY_KEY]);
  for (const group of groups) {
    // AND logic; all criteria must be across the threshold
    const shouldAlertFire = alertResults.every(result =>
    // Grab the result of the most recent bucket
    (0, _lodash.last)(result[group].shouldFire));
    const shouldAlertWarn = alertResults.every(result => (0, _lodash.last)(result[group].shouldWarn));
    // AND logic; because we need to evaluate all criteria, if one of them reports no data then the
    // whole alert is in a No Data/Error state
    const isNoData = alertResults.some(result => (0, _lodash.last)(result[group].isNoData));
    const isError = alertResults.some(result => result[group].isError);
    const nextState = isError ? _types.AlertStates.ERROR : isNoData ? _types.AlertStates.NO_DATA : shouldAlertFire ? _types.AlertStates.ALERT : shouldAlertWarn ? _types.AlertStates.WARNING : _types.AlertStates.OK;
    let reason;
    if (nextState === _types.AlertStates.ALERT || nextState === _types.AlertStates.WARNING) {
      reason = alertResults.map(result => (0, _messages.buildFiredAlertReason)({
        ...formatAlertResult(result[group], nextState === _types.AlertStates.WARNING),
        group
      })).join('\n');
      /*
       * Custom recovery actions aren't yet available in the alerting framework
       * Uncomment the code below once they've been implemented
       * Reference: https://github.com/elastic/kibana/issues/87048
       */
      // } else if (nextState === AlertStates.OK && prevState?.alertState === AlertStates.ALERT) {
      // reason = alertResults
      //   .map((result) => buildRecoveredAlertReason(formatAlertResult(result[group])))
      //   .join('\n');
    }

    /* NO DATA STATE HANDLING
     *
     * - `alertOnNoData` does not indicate IF the alert's next state is No Data, but whether or not the user WANTS TO BE ALERTED
     *   if the state were No Data.
     * - `alertOnGroupDisappear`, on the other hand, determines whether or not it's possible to return a No Data state
     *   when a group disappears.
     *
     * This means we need to handle the possibility that `alertOnNoData` is false, but `alertOnGroupDisappear` is true
     *
     * nextState === NO_DATA would be true on both { '*': No Data } or, e.g. { 'a': No Data, 'b': OK, 'c': OK }, but if the user
     * has for some reason disabled `alertOnNoData` and left `alertOnGroupDisappear` enabled, they would only care about the latter
     * possibility. In this case, use hasGroups to determine whether to alert on a potential No Data state
     *
     * If `alertOnNoData` is true but `alertOnGroupDisappear` is false, we don't need to worry about the {a, b, c} possibility.
     * At this point in the function, a false `alertOnGroupDisappear` would already have prevented group 'a' from being evaluated at all.
     */
    if (alertOnNoData || alertOnGroupDisappear && hasGroups) {
      // In the previous line we've determined if the user is interested in No Data states, so only now do we actually
      // check to see if a No Data state has occurred
      if (nextState === _types.AlertStates.NO_DATA) {
        reason = alertResults.filter(result => result[group].isNoData).map(result => (0, _messages.buildNoDataAlertReason)({
          ...result[group],
          group
        })).join('\n');
      } else if (nextState === _types.AlertStates.ERROR) {
        reason = alertResults.filter(result => result[group].isError).map(result => (0, _messages.buildErrorAlertReason)(result[group].metric)).join('\n');
      }
    }
    if (reason) {
      var _ref;
      const firstResult = (0, _lodash.first)(alertResults);
      const timestamp = (_ref = firstResult && firstResult[group].timestamp) !== null && _ref !== void 0 ? _ref : (0, _moment.default)().toISOString();
      const actionGroupId = nextState === _types.AlertStates.OK ? _common.RecoveredActionGroup.id : nextState === _types.AlertStates.WARNING ? WARNING_ACTIONS.id : FIRED_ACTIONS.id;
      const alertInstance = alertInstanceFactory(`${group}`, reason);
      alertInstance.scheduleActions(actionGroupId, {
        group,
        alertState: _messages.stateToAlertMessage[nextState],
        reason,
        timestamp,
        value: mapToConditionsLookup(alertResults, result => formatAlertResult(result[group]).currentValue),
        threshold: mapToConditionsLookup(alertResults, result => formatAlertResult(result[group]).threshold),
        metric: mapToConditionsLookup(criteria, c => c.metric)
      });
    }
  }
  return {
    groups,
    groupBy: params.groupBy,
    filterQuery: params.filterQuery
  };
});
exports.createMetricThresholdExecutor = createMetricThresholdExecutor;
const FIRED_ACTIONS = exports.FIRED_ACTIONS = {
  id: 'metrics.threshold.fired',
  name: _i18n.i18n.translate('xpack.infra.metrics.alerting.threshold.fired', {
    defaultMessage: 'Alert'
  })
};
const WARNING_ACTIONS = exports.WARNING_ACTIONS = {
  id: 'metrics.threshold.warning',
  name: _i18n.i18n.translate('xpack.infra.metrics.alerting.threshold.warning', {
    defaultMessage: 'Warning'
  })
};
const mapToConditionsLookup = (list, mapFn) => list.map(mapFn).reduce((result, value, i) => ({
  ...result,
  [`condition${i}`]: value
}), {});
const formatAlertResult = (alertResult, useWarningThreshold) => {
  const {
    metric,
    currentValue,
    threshold,
    comparator,
    warningThreshold,
    warningComparator
  } = alertResult;
  const noDataValue = _i18n.i18n.translate('xpack.infra.metrics.alerting.threshold.noDataFormattedValue', {
    defaultMessage: '[NO DATA]'
  });
  if (!metric.endsWith('.pct')) return {
    ...alertResult,
    currentValue: currentValue !== null && currentValue !== void 0 ? currentValue : noDataValue
  };
  const formatter = (0, _formatters.createFormatter)('percent');
  const thresholdToFormat = useWarningThreshold ? warningThreshold : threshold;
  const comparatorToFormat = useWarningThreshold ? warningComparator : comparator;
  return {
    ...alertResult,
    currentValue: currentValue !== null && typeof currentValue !== 'undefined' ? formatter(currentValue) : noDataValue,
    threshold: Array.isArray(thresholdToFormat) ? thresholdToFormat.map(v => formatter(v)) : thresholdToFormat,
    comparator: comparatorToFormat
  };
};