"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.logSourceFieldColumnConfigurationRT = exports.logSourceConfigurationRT = exports.logSourceConfigurationPropertiesRT = exports.logSourceConfigurationOriginRT = exports.logSourceColumnConfigurationRT = exports.logIndexReferenceRT = exports.logIndexPatternReferenceRT = exports.logIndexNameReferenceRT = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const logSourceConfigurationOriginRT = exports.logSourceConfigurationOriginRT = rt.keyof({
  fallback: null,
  internal: null,
  stored: null
});
const logSourceFieldsConfigurationRT = rt.strict({
  container: rt.string,
  host: rt.string,
  pod: rt.string,
  timestamp: rt.string,
  tiebreaker: rt.string,
  message: rt.array(rt.string)
});
const logSourceCommonColumnConfigurationRT = rt.strict({
  id: rt.string
});
const logSourceTimestampColumnConfigurationRT = rt.strict({
  timestampColumn: logSourceCommonColumnConfigurationRT
});
const logSourceMessageColumnConfigurationRT = rt.strict({
  messageColumn: logSourceCommonColumnConfigurationRT
});
const logSourceFieldColumnConfigurationRT = exports.logSourceFieldColumnConfigurationRT = rt.strict({
  fieldColumn: rt.intersection([logSourceCommonColumnConfigurationRT, rt.strict({
    field: rt.string
  })])
});
const logSourceColumnConfigurationRT = exports.logSourceColumnConfigurationRT = rt.union([logSourceTimestampColumnConfigurationRT, logSourceMessageColumnConfigurationRT, logSourceFieldColumnConfigurationRT]);
// Kibana index pattern
const logIndexPatternReferenceRT = exports.logIndexPatternReferenceRT = rt.type({
  type: rt.literal('index_pattern'),
  indexPatternId: rt.string
});
// Legacy support
const logIndexNameReferenceRT = exports.logIndexNameReferenceRT = rt.type({
  type: rt.literal('index_name'),
  indexName: rt.string
});
const logIndexReferenceRT = exports.logIndexReferenceRT = rt.union([logIndexPatternReferenceRT, logIndexNameReferenceRT]);
const logSourceConfigurationPropertiesRT = exports.logSourceConfigurationPropertiesRT = rt.strict({
  name: rt.string,
  description: rt.string,
  logIndices: logIndexReferenceRT,
  fields: logSourceFieldsConfigurationRT,
  logColumns: rt.array(logSourceColumnConfigurationRT)
});
const logSourceConfigurationRT = exports.logSourceConfigurationRT = rt.exact(rt.intersection([rt.type({
  id: rt.string,
  origin: logSourceConfigurationOriginRT,
  configuration: logSourceConfigurationPropertiesRT
}), rt.partial({
  updatedAt: rt.number,
  version: rt.string
})]));