"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.logTimestampColumnRT = exports.logMessagePartRT = exports.logMessageFieldPartRT = exports.logMessageConstantPartRT = exports.logMessageColumnRT = exports.logFieldColumnRT = exports.logEntryRT = exports.logEntryFieldRT = exports.logEntryContextRT = exports.logColumnRT = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _typed_json = require("../typed_json");
var _log_entry_cursor = require("./log_entry_cursor");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * message parts
 */
const logMessageConstantPartRT = exports.logMessageConstantPartRT = rt.type({
  constant: rt.string
});
const logMessageFieldPartRT = exports.logMessageFieldPartRT = rt.type({
  field: rt.string,
  value: _typed_json.jsonArrayRT,
  highlights: rt.array(rt.string)
});
const logMessagePartRT = exports.logMessagePartRT = rt.union([logMessageConstantPartRT, logMessageFieldPartRT]);
/**
 * columns
 */

const logTimestampColumnRT = exports.logTimestampColumnRT = rt.type({
  columnId: rt.string,
  timestamp: rt.number
});
const logFieldColumnRT = exports.logFieldColumnRT = rt.type({
  columnId: rt.string,
  field: rt.string,
  value: _typed_json.jsonArrayRT,
  highlights: rt.array(rt.string)
});
const logMessageColumnRT = exports.logMessageColumnRT = rt.type({
  columnId: rt.string,
  message: rt.array(logMessagePartRT)
});
const logColumnRT = exports.logColumnRT = rt.union([logTimestampColumnRT, logFieldColumnRT, logMessageColumnRT]);
/**
 * fields
 */
const logEntryContextRT = exports.logEntryContextRT = rt.union([rt.type({}), rt.type({
  'container.id': rt.string
}), rt.type({
  'host.name': rt.string,
  'log.file.path': rt.string
})]);
const logEntryFieldRT = exports.logEntryFieldRT = rt.type({
  field: rt.string,
  value: _typed_json.jsonArrayRT
});
/**
 * entry
 */

const logEntryRT = exports.logEntryRT = rt.type({
  id: rt.string,
  index: rt.string,
  cursor: _log_entry_cursor.logEntryCursorRT,
  columns: rt.array(logColumnRT),
  context: logEntryContextRT
});