"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.partitionField = exports.jobSourceConfigurationRT = exports.jobCustomSettingsRT = exports.getJobIdPrefix = exports.getJobId = exports.getDatafeedId = exports.filterDatasetFilter = exports.datasetFilterRT = exports.combineDatasetFilters = exports.categoriesMessageField = exports.bucketSpan = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const bucketSpan = exports.bucketSpan = 900000;
const categoriesMessageField = exports.categoriesMessageField = 'message';
const partitionField = exports.partitionField = 'event.dataset';
const getJobIdPrefix = (spaceId, sourceId) => `kibana-logs-ui-${spaceId}-${sourceId}-`;
exports.getJobIdPrefix = getJobIdPrefix;
const getJobId = (spaceId, sourceId, jobType) => `${getJobIdPrefix(spaceId, sourceId)}${jobType}`;
exports.getJobId = getJobId;
const getDatafeedId = (spaceId, sourceId, jobType) => `datafeed-${getJobId(spaceId, sourceId, jobType)}`;
exports.getDatafeedId = getDatafeedId;
const datasetFilterRT = exports.datasetFilterRT = rt.union([rt.strict({
  type: rt.literal('includeAll')
}), rt.strict({
  type: rt.literal('includeSome'),
  datasets: rt.array(rt.string)
})]);
const jobSourceConfigurationRT = exports.jobSourceConfigurationRT = rt.partial({
  indexPattern: rt.string,
  timestampField: rt.string,
  bucketSpan: rt.number,
  datasetFilter: datasetFilterRT
});
const jobCustomSettingsRT = exports.jobCustomSettingsRT = rt.partial({
  job_revision: rt.number,
  logs_source_config: jobSourceConfigurationRT
});
const combineDatasetFilters = (firstFilter, secondFilter) => {
  if (firstFilter.type === 'includeAll' && secondFilter.type === 'includeAll') {
    return {
      type: 'includeAll'
    };
  }
  const includedDatasets = new Set([...(firstFilter.type === 'includeSome' ? firstFilter.datasets : []), ...(secondFilter.type === 'includeSome' ? secondFilter.datasets : [])]);
  return {
    type: 'includeSome',
    datasets: [...includedDatasets]
  };
};
exports.combineDatasetFilters = combineDatasetFilters;
const filterDatasetFilter = (datasetFilter, predicate) => {
  if (datasetFilter.type === 'includeAll') {
    return datasetFilter;
  } else {
    const newDatasets = datasetFilter.datasets.filter(predicate);
    if (newDatasets.length > 0) {
      return {
        type: 'includeSome',
        datasets: newDatasets
      };
    } else {
      return {
        type: 'includeAll'
      };
    }
  }
};
exports.filterDatasetFilter = filterDatasetFilter;