"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SnapshotRequestRT = exports.SnapshotNodeResponseRT = exports.SnapshotNodeRT = exports.SnapshotNodePathRT = exports.SnapshotNodeMetricRT = exports.SnapshotNamedMetricInputRT = exports.SnapshotMetricInputRT = exports.SnapshotGroupByRT = exports.SnapshotCustomMetricInputRT = exports.SnapshotCustomAggregationRT = exports.SNAPSHOT_CUSTOM_AGGREGATIONS = exports.InfraTimerangeInputRT = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _types = require("../inventory_models/types");
var _metrics_api = require("./metrics_api");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SnapshotNodePathRT = exports.SnapshotNodePathRT = rt.intersection([rt.type({
  value: rt.string,
  label: rt.string
}), rt.partial({
  ip: rt.union([rt.string, rt.null])
})]);
const SnapshotNodeMetricOptionalRT = rt.partial({
  value: rt.union([rt.number, rt.null]),
  avg: rt.union([rt.number, rt.null]),
  max: rt.union([rt.number, rt.null]),
  timeseries: _metrics_api.MetricsAPISeriesRT
});
const SnapshotNodeMetricRequiredRT = rt.type({
  name: rt.union([_types.SnapshotMetricTypeRT, rt.string])
});
const SnapshotNodeMetricRT = exports.SnapshotNodeMetricRT = rt.intersection([SnapshotNodeMetricRequiredRT, SnapshotNodeMetricOptionalRT]);
const SnapshotNodeRT = exports.SnapshotNodeRT = rt.type({
  metrics: rt.array(SnapshotNodeMetricRT),
  path: rt.array(SnapshotNodePathRT),
  name: rt.string
});
const SnapshotNodeResponseRT = exports.SnapshotNodeResponseRT = rt.type({
  nodes: rt.array(SnapshotNodeRT),
  interval: rt.string
});
const InfraTimerangeInputRT = exports.InfraTimerangeInputRT = rt.intersection([rt.type({
  interval: rt.string,
  to: rt.number,
  from: rt.number
}), rt.partial({
  lookbackSize: rt.number,
  ignoreLookback: rt.boolean,
  forceInterval: rt.boolean
})]);
const SnapshotGroupByRT = exports.SnapshotGroupByRT = rt.array(rt.partial({
  label: rt.union([rt.string, rt.null]),
  field: rt.union([rt.string, rt.null])
}));
const SnapshotNamedMetricInputRT = exports.SnapshotNamedMetricInputRT = rt.type({
  type: _types.SnapshotMetricTypeRT
});
const SNAPSHOT_CUSTOM_AGGREGATIONS = exports.SNAPSHOT_CUSTOM_AGGREGATIONS = ['avg', 'max', 'min', 'rate'];
const snapshotCustomAggregationKeys = SNAPSHOT_CUSTOM_AGGREGATIONS.reduce((acc, agg) => ({
  ...acc,
  [agg]: null
}), {});
const SnapshotCustomAggregationRT = exports.SnapshotCustomAggregationRT = rt.keyof(snapshotCustomAggregationKeys);
const SnapshotCustomMetricInputRT = exports.SnapshotCustomMetricInputRT = rt.intersection([rt.type({
  type: rt.literal('custom'),
  field: rt.string,
  aggregation: SnapshotCustomAggregationRT,
  id: rt.string
}), rt.partial({
  label: rt.string
})]);
const SnapshotMetricInputRT = exports.SnapshotMetricInputRT = rt.union([SnapshotNamedMetricInputRT, SnapshotCustomMetricInputRT]);
const SnapshotRequestRT = exports.SnapshotRequestRT = rt.intersection([rt.type({
  timerange: InfraTimerangeInputRT,
  metrics: rt.array(SnapshotMetricInputRT),
  groupBy: rt.union([SnapshotGroupByRT, rt.null]),
  nodeType: _types.ItemTypeRT,
  sourceId: rt.string
}), rt.partial({
  accountId: rt.string,
  region: rt.string,
  filterQuery: rt.union([rt.string, rt.null]),
  includeTimeseries: rt.boolean,
  overrideCompositeSize: rt.number
})]);