"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NodeDetailsRequestRT = exports.NodeDetailsMetricDataResponseRT = exports.NodeDetailsMetricDataRT = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _types = require("../inventory_models/types");
var _snapshot_api = require("./snapshot_api");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NodeDetailsDataPointRT = rt.intersection([rt.type({
  timestamp: rt.number
}), rt.partial({
  value: rt.union([rt.number, rt.null])
})]);
const NodeDetailsDataSeriesRT = rt.type({
  id: rt.string,
  label: rt.string,
  data: rt.array(NodeDetailsDataPointRT)
});
const NodeDetailsMetricDataRT = exports.NodeDetailsMetricDataRT = rt.intersection([rt.partial({
  id: rt.union([_types.InventoryMetricRT, rt.null])
}), rt.type({
  series: rt.array(NodeDetailsDataSeriesRT)
})]);
const NodeDetailsMetricDataResponseRT = exports.NodeDetailsMetricDataResponseRT = rt.type({
  metrics: rt.array(NodeDetailsMetricDataRT)
});
const NodeDetailsRequestRT = exports.NodeDetailsRequestRT = rt.intersection([rt.type({
  nodeType: _types.ItemTypeRT,
  nodeId: rt.string,
  metrics: rt.array(_types.InventoryMetricRT),
  timerange: _snapshot_api.InfraTimerangeInputRT,
  sourceId: rt.string
}), rt.partial({
  cloudId: rt.union([rt.string, rt.null])
})]);

// export type NodeDetailsRequest = InfraWrappableRequest<NodesArgs & SourceArgs>;