"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.timeRangeRT = exports.metricsExplorerSeriesRT = exports.metricsExplorerRowRT = exports.metricsExplorerResponseRT = exports.metricsExplorerRequestBodyRequiredFieldsRT = exports.metricsExplorerRequestBodyRT = exports.metricsExplorerRequestBodyOptionalFieldsRT = exports.metricsExplorerPageInfoRT = exports.metricsExplorerMetricRequiredFieldsRT = exports.metricsExplorerMetricRT = exports.metricsExplorerMetricOptionalFieldsRT = exports.metricsExplorerColumnTypeRT = exports.metricsExplorerColumnRT = exports.metricsExplorerAggregationRT = exports.afterKeyObjectRT = exports.METRIC_EXPLORER_AGGREGATIONS = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const METRIC_EXPLORER_AGGREGATIONS = exports.METRIC_EXPLORER_AGGREGATIONS = ['avg', 'max', 'min', 'cardinality', 'rate', 'count', 'sum', 'p95', 'p99'];
const metricsExplorerAggregationKeys = METRIC_EXPLORER_AGGREGATIONS.reduce((acc, agg) => ({
  ...acc,
  [agg]: null
}), {});
const metricsExplorerAggregationRT = exports.metricsExplorerAggregationRT = rt.keyof(metricsExplorerAggregationKeys);
const metricsExplorerMetricRequiredFieldsRT = exports.metricsExplorerMetricRequiredFieldsRT = rt.type({
  aggregation: metricsExplorerAggregationRT
});
const metricsExplorerMetricOptionalFieldsRT = exports.metricsExplorerMetricOptionalFieldsRT = rt.partial({
  field: rt.union([rt.string, rt.undefined])
});
const metricsExplorerMetricRT = exports.metricsExplorerMetricRT = rt.intersection([metricsExplorerMetricRequiredFieldsRT, metricsExplorerMetricOptionalFieldsRT]);
const timeRangeRT = exports.timeRangeRT = rt.type({
  field: rt.string,
  from: rt.number,
  to: rt.number,
  interval: rt.string
});
const metricsExplorerRequestBodyRequiredFieldsRT = exports.metricsExplorerRequestBodyRequiredFieldsRT = rt.type({
  timerange: timeRangeRT,
  indexPattern: rt.string,
  metrics: rt.array(metricsExplorerMetricRT)
});
const groupByRT = rt.union([rt.string, rt.null, rt.undefined]);
const afterKeyObjectRT = exports.afterKeyObjectRT = rt.record(rt.string, rt.union([rt.string, rt.null]));
const metricsExplorerRequestBodyOptionalFieldsRT = exports.metricsExplorerRequestBodyOptionalFieldsRT = rt.partial({
  groupBy: rt.union([groupByRT, rt.array(groupByRT)]),
  afterKey: rt.union([rt.string, rt.null, rt.undefined, afterKeyObjectRT]),
  limit: rt.union([rt.number, rt.null, rt.undefined]),
  filterQuery: rt.union([rt.string, rt.null, rt.undefined]),
  forceInterval: rt.boolean,
  dropLastBucket: rt.boolean
});
const metricsExplorerRequestBodyRT = exports.metricsExplorerRequestBodyRT = rt.intersection([metricsExplorerRequestBodyRequiredFieldsRT, metricsExplorerRequestBodyOptionalFieldsRT]);
const metricsExplorerPageInfoRT = exports.metricsExplorerPageInfoRT = rt.type({
  total: rt.number,
  afterKey: rt.union([rt.string, rt.null, afterKeyObjectRT])
});
const metricsExplorerColumnTypeRT = exports.metricsExplorerColumnTypeRT = rt.keyof({
  date: null,
  number: null,
  string: null
});
const metricsExplorerColumnRT = exports.metricsExplorerColumnRT = rt.type({
  name: rt.string,
  type: metricsExplorerColumnTypeRT
});
const metricsExplorerRowRT = exports.metricsExplorerRowRT = rt.intersection([rt.type({
  timestamp: rt.number
}), rt.record(rt.string, rt.union([rt.string, rt.number, rt.null, rt.undefined, rt.array(rt.object)]))]);
const metricsExplorerSeriesRT = exports.metricsExplorerSeriesRT = rt.intersection([rt.type({
  id: rt.string,
  columns: rt.array(metricsExplorerColumnRT),
  rows: rt.array(metricsExplorerRowRT)
}), rt.partial({
  keys: rt.array(rt.string)
})]);
const metricsExplorerResponseRT = exports.metricsExplorerResponseRT = rt.type({
  series: rt.array(metricsExplorerSeriesRT),
  pageInfo: metricsExplorerPageInfoRT
});