"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLogSourceStatusSuccessResponsePayloadRT = exports.getLogSourceStatusRequestParamsRT = exports.getLogSourceStatusPath = exports.LOG_SOURCE_STATUS_PATH_SUFFIX = exports.LOG_SOURCE_STATUS_PATH = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _shared = require("../shared");
var _common = require("./common");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LOG_SOURCE_STATUS_PATH_SUFFIX = exports.LOG_SOURCE_STATUS_PATH_SUFFIX = 'status';
const LOG_SOURCE_STATUS_PATH = exports.LOG_SOURCE_STATUS_PATH = `${_common.LOG_SOURCE_CONFIGURATION_PATH}/${LOG_SOURCE_STATUS_PATH_SUFFIX}`;
const getLogSourceStatusPath = sourceId => `${(0, _common.getLogSourceConfigurationPath)(sourceId)}/${LOG_SOURCE_STATUS_PATH_SUFFIX}`;

/**
 * request
 */
exports.getLogSourceStatusPath = getLogSourceStatusPath;
const getLogSourceStatusRequestParamsRT = exports.getLogSourceStatusRequestParamsRT = rt.type({
  // the id of the source configuration
  sourceId: rt.string
});
/**
 * response
 */

const logIndexFieldRT = rt.strict({
  name: rt.string,
  type: rt.string,
  searchable: rt.boolean,
  aggregatable: rt.boolean
});
const logIndexStatusRT = rt.keyof({
  missing: null,
  empty: null,
  available: null
});
const logSourceStatusRT = rt.strict({
  logIndexStatus: logIndexStatusRT
});
const getLogSourceStatusSuccessResponsePayloadRT = exports.getLogSourceStatusSuccessResponsePayloadRT = rt.intersection([rt.type({
  data: logSourceStatusRT
}), rt.partial({
  timing: _shared.routeTimingMetadataRT
})]);