"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLatestLogEntryCategoryDatasetsStatsSuccessResponsePayloadRT = exports.getLatestLogEntryCategoryDatasetsStatsRequestPayloadRT = exports.LOG_ANALYSIS_GET_LATEST_LOG_ENTRY_CATEGORY_DATASETS_STATS_PATH = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _shared = require("../../shared");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LOG_ANALYSIS_GET_LATEST_LOG_ENTRY_CATEGORY_DATASETS_STATS_PATH = exports.LOG_ANALYSIS_GET_LATEST_LOG_ENTRY_CATEGORY_DATASETS_STATS_PATH = '/api/infra/log_analysis/results/latest_log_entry_category_datasets_stats';
const categorizerStatusRT = rt.keyof({
  ok: null,
  warn: null
});
/**
 * request
 */

const getLatestLogEntryCategoryDatasetsStatsRequestPayloadRT = exports.getLatestLogEntryCategoryDatasetsStatsRequestPayloadRT = rt.type({
  data: rt.type({
    // the ids of the categorization jobs
    jobIds: rt.array(rt.string),
    // the time range to fetch the category datasets stats for
    timeRange: _shared.timeRangeRT,
    // the categorizer statuses to include stats for, empty means all
    includeCategorizerStatuses: rt.array(categorizerStatusRT)
  })
});
/**
 * response
 */

const logEntryCategoriesDatasetStatsRT = rt.type({
  categorization_status: categorizerStatusRT,
  categorized_doc_count: rt.number,
  dataset: rt.string,
  dead_category_count: rt.number,
  failed_category_count: rt.number,
  frequent_category_count: rt.number,
  job_id: rt.string,
  log_time: rt.number,
  rare_category_count: rt.number,
  total_category_count: rt.number
});
const getLatestLogEntryCategoryDatasetsStatsSuccessResponsePayloadRT = exports.getLatestLogEntryCategoryDatasetsStatsSuccessResponsePayloadRT = rt.intersection([rt.type({
  data: rt.type({
    datasetStats: rt.array(logEntryCategoriesDatasetStatsRT)
  })
}), rt.partial({
  timing: _shared.routeTimingMetadataRT
})]);