"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimelineParser = exports.ID = void 0;
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ID = exports.ID = 'timeline';
const PREFIX = '[';
const TimelineParser = function () {
  const Parser = this.Parser;
  const tokenizers = Parser.prototype.blockTokenizers;
  const methods = Parser.prototype.blockMethods;
  const tokenizeTimeline = function (eat, value, silent) {
    if (value.startsWith(PREFIX) === false || value.startsWith(PREFIX) === true && !value.includes('timelines?timeline=(id')) {
      return false;
    }
    let index = 0;
    const nextChar = value[index];
    if (nextChar !== PREFIX) {
      return false;
    }
    if (silent) {
      return true;
    }
    function readArg(open, close) {
      if (value[index] !== open) {
        throw new Error(i18n.NO_PARENTHESES);
      }
      index++;
      let body = '';
      let openBrackets = 0;
      for (; index < value.length; index++) {
        const char = value[index];
        if (char === close && openBrackets === 0) {
          index++;
          return body;
        } else if (char === close) {
          openBrackets--;
        } else if (char === open) {
          openBrackets++;
        }
        body += char;
      }
      return '';
    }
    const timelineTitle = readArg(PREFIX, ']');
    const timelineUrl = readArg('(', ')');
    const match = `[${timelineTitle}](${timelineUrl})`;
    return eat(match)({
      type: ID,
      match
    });
  };
  tokenizeTimeline.locator = (value, fromIndex) => {
    return value.indexOf(PREFIX, fromIndex);
  };
  tokenizers.timeline = tokenizeTimeline;
  methods.splice(methods.indexOf('url'), 0, ID);
};
exports.TimelineParser = TimelineParser;