"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CaseUserActionsResponseRt = exports.CaseUserActionAttributesRt = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _constants = require("./constants");
var _user = require("../user");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* To the next developer, if you add/removed fields here
 * make sure to check this file (x-pack/plugins/cases/server/services/user_actions/helpers.ts) too
 */
const UserActionFieldTypeRt = rt.union([rt.literal('comment'), rt.literal('connector'), rt.literal('description'), rt.literal('pushed'), rt.literal('tags'), rt.literal('title'), rt.literal('status'), rt.literal('settings'), rt.literal('sub_case'), rt.literal(_constants.OWNER_FIELD)]);
const UserActionFieldRt = rt.array(UserActionFieldTypeRt);
const UserActionRt = rt.union([rt.literal('add'), rt.literal('create'), rt.literal('delete'), rt.literal('update'), rt.literal('push-to-service')]);
const CaseUserActionBasicRT = rt.type({
  action_field: UserActionFieldRt,
  action: UserActionRt,
  action_at: rt.string,
  action_by: _user.UserRT,
  new_value: rt.union([rt.string, rt.null]),
  old_value: rt.union([rt.string, rt.null]),
  owner: rt.string
});
const CaseUserActionResponseRT = rt.intersection([CaseUserActionBasicRT, rt.type({
  action_id: rt.string,
  case_id: rt.string,
  comment_id: rt.union([rt.string, rt.null]),
  new_val_connector_id: rt.union([rt.string, rt.null]),
  old_val_connector_id: rt.union([rt.string, rt.null])
}), rt.partial({
  sub_case_id: rt.string
})]);
const CaseUserActionAttributesRt = exports.CaseUserActionAttributesRt = CaseUserActionBasicRT;
const CaseUserActionsResponseRt = exports.CaseUserActionsResponseRt = rt.array(CaseUserActionResponseRT);