"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SettingsComponent = exports.Settings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _context = require("../../../context");
var _toolbar_settings = require("./toolbar_settings");
var _autoplay_settings = require("./autoplay_settings");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * The Settings Popover for Canvas Shareable Workpads.
 */
const SettingsComponent = ({
  refs
}) => {
  const [isPopoverOpen, setPopoverOpen] = (0, _react.useState)(false);
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    color: "ghost",
    iconType: "gear",
    "aria-label": "Settings",
    onClick: () => setPopoverOpen(!isPopoverOpen)
  });
  const flattenPanelTree = (tree, array = []) => {
    array.push(tree);
    if (tree.items) {
      tree.items.forEach(item => {
        if (item.panel) {
          flattenPanelTree(item.panel, array);
          item.panel = item.panel.id;
        }
      });
    }
    return array;
  };
  const panels = flattenPanelTree({
    id: 0,
    title: 'Settings',
    items: [{
      name: 'Auto Play',
      icon: 'play',
      panel: {
        id: 1,
        title: 'Auto Play',
        content: /*#__PURE__*/_react.default.createElement(_autoplay_settings.AutoplaySettings, null)
      }
    }, {
      name: 'Toolbar',
      icon: 'boxesHorizontal',
      panel: {
        id: 2,
        title: 'Toolbar',
        content: /*#__PURE__*/_react.default.createElement(_toolbar_settings.ToolbarSettings, {
          onSetAutohide: () => setPopoverOpen(false)
        })
      }
    }]
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexEnd",
    justifyContent: "center",
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    closePopover: () => setPopoverOpen(false),
    id: "settings",
    isOpen: isPopoverOpen,
    button: button,
    panelPaddingSize: "none",
    anchorPosition: "upRight",
    insert: refs.stage.current ? {
      sibling: refs.stage.current,
      position: 'after'
    } : undefined
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: panels
  }))));
};

/**
 * A store-connected container for the `Settings` component.
 */
exports.SettingsComponent = SettingsComponent;
const Settings = () => {
  const [{
    refs
  }] = (0, _context.useCanvasShareableState)();
  return /*#__PURE__*/_react.default.createElement(SettingsComponent, {
    refs: refs
  });
};
exports.Settings = Settings;