"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.essql = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _arg_helpers = require("../../../public/lib/arg_helpers");
var _template_from_react_component = require("../../../public/lib/template_from_react_component");
var _i18n = require("../../../i18n");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  Essql: strings
} = _i18n.DataSourceStrings;
class EssqlDatasource extends _react.PureComponent {
  constructor(..._args) {
    super(..._args);
    (0, _defineProperty2.default)(this, "defaultQuery", `SELECT * FROM "${this.props.defaultIndex}"`);
    (0, _defineProperty2.default)(this, "getQuery", () => (0, _arg_helpers.getSimpleArg)(this.getArgName(), this.props.args)[0]);
    // TODO: This is a terrible way of doing defaults. We need to find a way to read the defaults for the function
    // and set them for the data source UI.
    (0, _defineProperty2.default)(this, "getArgName", () => {
      const {
        args
      } = this.props;
      if ((0, _arg_helpers.getSimpleArg)('_', args)[0]) {
        return '_';
      }
      if ((0, _arg_helpers.getSimpleArg)('q', args)[0]) {
        return 'q';
      }
      return 'query';
    });
    (0, _defineProperty2.default)(this, "setArg", (name, value) => {
      const {
        args,
        updateArgs
      } = this.props;
      updateArgs && updateArgs({
        ...args,
        ...(0, _arg_helpers.setSimpleArg)(name, value)
      });
    });
    (0, _defineProperty2.default)(this, "onChange", e => {
      const {
        value
      } = e.target;
      this.props.setInvalid(!value.trim());
      this.setArg(this.getArgName(), value);
    });
  }
  componentDidMount() {
    const query = this.getQuery();
    if (typeof query !== 'string') {
      this.setArg(this.getArgName(), this.defaultQuery);
    } else {
      this.props.setInvalid(!query.trim());
    }
  }
  render() {
    const {
      isInvalid
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      isInvalid: isInvalid,
      label: strings.getLabel(),
      labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: _i18n.SQL_URL,
        target: "_blank"
      }, strings.getLabelAppend()))
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
      placeholder: this.defaultQuery,
      isInvalid: isInvalid,
      className: "canvasTextArea__code",
      value: this.getQuery(),
      onChange: this.onChange,
      rows: 15
    }));
  }
}
EssqlDatasource.propTypes = {
  args: _propTypes.default.object.isRequired,
  updateArgs: _propTypes.default.func,
  isInvalid: _propTypes.default.bool,
  setInvalid: _propTypes.default.func,
  defaultIndex: _propTypes.default.string
};
const essql = () => ({
  name: 'essql',
  displayName: strings.getDisplayName(),
  help: strings.getHelp(),
  image: 'database',
  template: (0, _template_from_react_component.templateFromReactComponent)(EssqlDatasource)
});
exports.essql = essql;