"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.filterGroup = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _template_from_react_component = require("../../../public/lib/template_from_react_component");
var _i18n = require("../../../i18n");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  FilterGroup: strings
} = _i18n.ArgumentStrings;
const FilterGroupInput = ({
  onValueChange,
  argValue,
  argId,
  filterGroups
}) => {
  const [inputValue, setInputValue] = (0, _react.useState)('');
  const [addMode, setAddMode] = (0, _react.useState)(false);

  // make sure the argValue is always included in the filter group list
  const argValueChoice = argValue && !filterGroups.includes(argValue) ? [{
    text: argValue
  }] : [];
  const choices = [{
    text: 'No group',
    value: ''
  }].concat(argValueChoice, filterGroups.map(f => ({
    text: f
  })));
  const handleSelectGroup = ev => {
    const selected = ev.target.value;
    onValueChange(selected);
  };
  const handleAddGroup = ev => {
    // stop the form from submitting
    ev.preventDefault();
    // set the new value
    onValueChange(inputValue);
    // reset the component and input value
    setAddMode(false);
    setInputValue('');
  };
  const addForm = /*#__PURE__*/_react.default.createElement("form", {
    onSubmit: handleAddGroup
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    autoFocus: true,
    compressed: true,
    type: "text",
    value: inputValue,
    onChange: ev => setInputValue(ev.target.value)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "canvasSidebar__panel-noMinWidth"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    type: "submit",
    size: "s",
    onClick: handleAddGroup
  }, strings.getButtonSet()))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "danger",
    size: "xs",
    onClick: () => setAddMode(!addMode),
    flush: "left"
  }, strings.getButtonCancel()));
  const selectForm = /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    compressed: true,
    id: argId,
    value: argValue || '',
    options: choices,
    onChange: handleSelectGroup
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    onClick: () => setAddMode(!addMode),
    flush: "left"
  }, strings.getCreateNewGroup()));
  return addMode ? addForm : selectForm;
};
FilterGroupInput.propTypes = {
  onValueChange: _propTypes.default.func.isRequired,
  argValue: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number, _propTypes.default.bool]).isRequired,
  typeInstance: _propTypes.default.shape({
    name: _propTypes.default.string.isRequired
  }),
  argId: _propTypes.default.string.isRequired
};
const filterGroup = () => ({
  name: 'filterGroup',
  displayName: strings.getDisplayName(),
  help: strings.getHelp(),
  simpleTemplate: (0, _template_from_react_component.templateFromReactComponent)(FilterGroupInput)
});
exports.filterGroup = filterGroup;