"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CanvasSrcPlugin = void 0;
var _browser = require("./functions/browser");
var _expression_types = require("./expression_types");
var _renderers = require("./renderers");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
} /*
  * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
  * or more contributor license agreements. Licensed under the Elastic License
  * 2.0; you may not use this file except in compliance with the Elastic License
  * 2.0.
  */
/** @internal */
class CanvasSrcPlugin {
  setup(core, plugins) {
    plugins.canvas.addFunctions(_browser.functions);
    plugins.canvas.addTypes(_expression_types.typeFunctions);
    plugins.canvas.addRenderers(_renderers.renderFunctions);
    core.getStartServices().then(([coreStart, depsStart]) => {
      plugins.canvas.addRenderers(_renderers.renderFunctionFactories.map(factory => factory(coreStart, depsStart)));
    });
    plugins.canvas.addDatasourceUIs(async () => {
      // @ts-expect-error
      const {
        datasourceSpecs
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./canvas_addons')));
      return datasourceSpecs;
    });
    plugins.canvas.addElements(async () => {
      const {
        initializeElements
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./canvas_addons')));
      return initializeElements(core, plugins);
    });
    plugins.canvas.addModelUIs(async () => {
      // @ts-expect-error Untyped local
      const {
        modelSpecs
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./canvas_addons')));
      return modelSpecs;
    });
    plugins.canvas.addViewUIs(async () => {
      const {
        initializeViews
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./canvas_addons')));
      return initializeViews(core, plugins);
    });
    plugins.canvas.addArgumentUIs(async () => {
      const {
        initializeArgs
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./canvas_addons')));
      return initializeArgs(core, plugins);
    });
    plugins.canvas.addTagUIs(async () => {
      const {
        tagSpecs
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./canvas_addons')));
      return tagSpecs;
    });
    plugins.canvas.addTransformUIs(async () => {
      // @ts-expect-error Untyped local
      const {
        transformSpecs
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./canvas_addons')));
      return transformSpecs;
    });
  }
  start(core, plugins) {}
}
exports.CanvasSrcPlugin = CanvasSrcPlugin;