"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.suggestionsRouteRepository = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _common = require("../../../observability/common");
var _get_suggestions = require("../lib/suggestions/get_suggestions");
var _aggregated_transactions = require("../lib/helpers/aggregated_transactions");
var _setup_request = require("../lib/helpers/setup_request");
var _create_apm_server_route = require("./create_apm_server_route");
var _create_apm_server_route_repository = require("./create_apm_server_route_repository");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const suggestionsRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/suggestions',
  params: t.partial({
    query: t.type({
      field: t.string,
      string: t.string
    })
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const setup = await (0, _setup_request.setupRequest)(resources);
    const {
      context,
      params
    } = resources;
    const {
      field,
      string
    } = params.query;
    const searchAggregatedTransactions = await (0, _aggregated_transactions.getSearchAggregatedTransactions)({
      apmEventClient: setup.apmEventClient,
      config: setup.config,
      kuery: ''
    });
    const size = await context.core.uiSettings.client.get(_common.maxSuggestions);
    const suggestions = await (0, _get_suggestions.getSuggestions)({
      field,
      searchAggregatedTransactions,
      setup,
      size,
      string
    });
    return suggestions;
  }
});
const suggestionsRouteRepository = exports.suggestionsRouteRepository = (0, _create_apm_server_route_repository.createApmServerRouteRepository)().add(suggestionsRoute);