"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.serviceMapRouteRepository = void 0;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var t = _interopRequireWildcard(require("io-ts"));
var _license_check = require("../../common/license_check");
var _service_map = require("../../common/service_map");
var _feature = require("../feature");
var _aggregated_transactions = require("../lib/helpers/aggregated_transactions");
var _setup_request = require("../lib/helpers/setup_request");
var _get_service_map = require("../lib/service_map/get_service_map");
var _get_service_map_backend_node_info = require("../lib/service_map/get_service_map_backend_node_info");
var _get_service_map_service_node_info = require("../lib/service_map/get_service_map_service_node_info");
var _create_apm_server_route = require("./create_apm_server_route");
var _create_apm_server_route_repository = require("./create_apm_server_route_repository");
var _default_api_types = require("./default_api_types");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const serviceMapRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/service-map',
  params: t.type({
    query: t.intersection([t.partial({
      serviceName: t.string
    }), _default_api_types.environmentRt, _default_api_types.rangeRt])
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const {
      config,
      context,
      params,
      logger
    } = resources;
    if (!config.serviceMapEnabled) {
      throw _boom.default.notFound();
    }
    if (!(0, _license_check.isActivePlatinumLicense)(context.licensing.license)) {
      throw _boom.default.forbidden(_service_map.invalidLicenseMessage);
    }
    (0, _feature.notifyFeatureUsage)({
      licensingPlugin: context.licensing,
      featureName: 'serviceMaps'
    });
    const setup = await (0, _setup_request.setupRequest)(resources);
    const {
      query: {
        serviceName,
        environment,
        start,
        end
      }
    } = params;
    const searchAggregatedTransactions = await (0, _aggregated_transactions.getSearchAggregatedTransactions)({
      apmEventClient: setup.apmEventClient,
      config: setup.config,
      start,
      end,
      kuery: ''
    });
    return (0, _get_service_map.getServiceMap)({
      setup,
      serviceName,
      environment,
      searchAggregatedTransactions,
      logger,
      start,
      end
    });
  }
});
const serviceMapServiceNodeRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/service-map/service/{serviceName}',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([_default_api_types.environmentRt, _default_api_types.rangeRt])
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const {
      config,
      context,
      params
    } = resources;
    if (!config.serviceMapEnabled) {
      throw _boom.default.notFound();
    }
    if (!(0, _license_check.isActivePlatinumLicense)(context.licensing.license)) {
      throw _boom.default.forbidden(_service_map.invalidLicenseMessage);
    }
    const setup = await (0, _setup_request.setupRequest)(resources);
    const {
      path: {
        serviceName
      },
      query: {
        environment,
        start,
        end
      }
    } = params;
    const searchAggregatedTransactions = await (0, _aggregated_transactions.getSearchAggregatedTransactions)({
      apmEventClient: setup.apmEventClient,
      config: setup.config,
      start,
      end,
      kuery: ''
    });
    return (0, _get_service_map_service_node_info.getServiceMapServiceNodeInfo)({
      environment,
      setup,
      serviceName,
      searchAggregatedTransactions,
      start,
      end
    });
  }
});
const serviceMapBackendNodeRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/service-map/backend',
  params: t.type({
    query: t.intersection([t.type({
      backendName: t.string
    }), _default_api_types.environmentRt, _default_api_types.rangeRt])
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const {
      config,
      context,
      params
    } = resources;
    if (!config.serviceMapEnabled) {
      throw _boom.default.notFound();
    }
    if (!(0, _license_check.isActivePlatinumLicense)(context.licensing.license)) {
      throw _boom.default.forbidden(_service_map.invalidLicenseMessage);
    }
    const setup = await (0, _setup_request.setupRequest)(resources);
    const {
      query: {
        backendName,
        environment,
        start,
        end
      }
    } = params;
    return (0, _get_service_map_backend_node_info.getServiceMapBackendNodeInfo)({
      environment,
      setup,
      backendName,
      start,
      end
    });
  }
});
const serviceMapRouteRepository = exports.serviceMapRouteRepository = (0, _create_apm_server_route_repository.createApmServerRouteRepository)().add(serviceMapRoute).add(serviceMapServiceNodeRoute).add(serviceMapBackendNodeRoute);