"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.inspectableEsQueriesMap = void 0;
exports.registerRoutes = registerRoutes;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var t = _interopRequireWildcard(require("io-ts"));
var _errors = require("@elastic/elasticsearch/lib/errors");
var _elasticApmNode = _interopRequireDefault(require("elastic-apm-node"));
var _lodash = require("lodash");
var _serverRouteRepository = require("@kbn/server-route-repository");
var _merge_rt = require("@kbn/io-ts-utils/merge_rt");
var _json_rt = require("@kbn/io-ts-utils/json_rt");
var _pick_keys = require("../../../common/utils/pick_keys");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const inspectRt = t.exact(t.partial({
  query: t.exact(t.partial({
    _inspect: _json_rt.jsonRt.pipe(t.boolean)
  }))
}));
const CLIENT_CLOSED_REQUEST = {
  statusCode: 499,
  body: {
    message: 'Client closed request'
  }
};
const inspectableEsQueriesMap = exports.inspectableEsQueriesMap = new WeakMap();
function registerRoutes({
  core,
  repository,
  plugins,
  logger,
  config,
  ruleDataClient,
  telemetryUsageCounter
}) {
  const routes = repository.getRoutes();
  const router = core.setup.http.createRouter();
  routes.forEach(route => {
    const {
      params,
      endpoint,
      options,
      handler
    } = route;
    const {
      method,
      pathname
    } = (0, _serverRouteRepository.parseEndpoint)(endpoint);
    router[method]({
      path: pathname,
      options,
      validate: _serverRouteRepository.routeValidationObject
    }, async (context, request, response) => {
      if (_elasticApmNode.default.isStarted()) {
        _elasticApmNode.default.addLabels({
          plugin: 'apm'
        });
      }

      // init debug queries
      inspectableEsQueriesMap.set(request, []);
      try {
        var _validatedParams$quer;
        const runtimeType = params ? (0, _merge_rt.mergeRt)(params, inspectRt) : inspectRt;
        const validatedParams = (0, _serverRouteRepository.decodeRequestParams)((0, _pick_keys.pickKeys)(request, 'params', 'body', 'query'), runtimeType);
        const {
          aborted,
          data
        } = await Promise.race([handler({
          request,
          context,
          config,
          logger,
          core,
          plugins,
          telemetryUsageCounter,
          params: (0, _lodash.merge)({
            query: {
              _inspect: false
            }
          }, validatedParams),
          ruleDataClient
        }).then(value => {
          return {
            aborted: false,
            data: value
          };
        }), request.events.aborted$.toPromise().then(() => {
          return {
            aborted: true,
            data: undefined
          };
        })]);
        if (aborted) {
          return response.custom(CLIENT_CLOSED_REQUEST);
        }
        if (Array.isArray(data)) {
          throw new Error('Return type cannot be an array');
        }
        const body = (_validatedParams$quer = validatedParams.query) !== null && _validatedParams$quer !== void 0 && _validatedParams$quer._inspect ? {
          ...data,
          _inspect: inspectableEsQueriesMap.get(request)
        } : {
          ...data
        };
        if (!options.disableTelemetry && telemetryUsageCounter) {
          telemetryUsageCounter.incrementCounter({
            counterName: `${method.toUpperCase()} ${pathname}`,
            counterType: 'success'
          });
        }
        return response.ok({
          body
        });
      } catch (error) {
        logger.error(error);
        if (!options.disableTelemetry && telemetryUsageCounter) {
          telemetryUsageCounter.incrementCounter({
            counterName: `${method.toUpperCase()} ${pathname}`,
            counterType: 'error'
          });
        }
        const opts = {
          statusCode: 500,
          body: {
            message: error.message,
            attributes: {
              _inspect: inspectableEsQueriesMap.get(request)
            }
          }
        };
        if (error instanceof _errors.RequestAbortedError) {
          return response.custom((0, _lodash.merge)(opts, CLIENT_CLOSED_REQUEST));
        }
        if (_boom.default.isBoom(error)) {
          opts.statusCode = error.output.statusCode;
        }
        return response.custom(opts);
      } finally {
        // cleanup
        inspectableEsQueriesMap.delete(request);
      }
    });
  });
}