"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.metricsRouteRepository = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _setup_request = require("../lib/helpers/setup_request");
var _get_metrics_chart_data_by_agent = require("../lib/metrics/get_metrics_chart_data_by_agent");
var _create_apm_server_route = require("./create_apm_server_route");
var _create_apm_server_route_repository = require("./create_apm_server_route_repository");
var _default_api_types = require("./default_api_types");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const metricsChartsRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/services/{serviceName}/metrics/charts',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([t.type({
      agentName: t.string
    }), t.partial({
      serviceNodeName: t.string
    }), _default_api_types.environmentRt, _default_api_types.kueryRt, _default_api_types.rangeRt])
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const {
      params
    } = resources;
    const setup = await (0, _setup_request.setupRequest)(resources);
    const {
      serviceName
    } = params.path;
    const {
      agentName,
      environment,
      kuery,
      serviceNodeName,
      start,
      end
    } = params.query;
    return await (0, _get_metrics_chart_data_by_agent.getMetricsChartDataByAgent)({
      environment,
      kuery,
      setup,
      serviceName,
      agentName,
      serviceNodeName,
      start,
      end
    });
  }
});
const metricsRouteRepository = exports.metricsRouteRepository = (0, _create_apm_server_route_repository.createApmServerRouteRepository)().add(metricsChartsRoute);