"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fallbackToTransactionsRouteRepository = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _get_is_using_transaction_events = require("../lib/helpers/aggregated_transactions/get_is_using_transaction_events");
var _setup_request = require("../lib/helpers/setup_request");
var _create_apm_server_route = require("./create_apm_server_route");
var _create_apm_server_route_repository = require("./create_apm_server_route_repository");
var _default_api_types = require("./default_api_types");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fallbackToTransactionsRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/fallback_to_transactions',
  params: t.partial({
    query: t.intersection([_default_api_types.kueryRt, t.partial(_default_api_types.rangeRt.props)])
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const setup = await (0, _setup_request.setupRequest)(resources);
    const {
      params: {
        query: {
          kuery,
          start,
          end
        }
      }
    } = resources;
    return {
      fallbackToTransactions: await (0, _get_is_using_transaction_events.getIsUsingTransactionEvents)({
        setup,
        kuery,
        start,
        end
      })
    };
  }
});
const fallbackToTransactionsRouteRepository = exports.fallbackToTransactionsRouteRepository = (0, _create_apm_server_route_repository.createApmServerRouteRepository)().add(fallbackToTransactionsRoute);