"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.taskInstanceToAlertTaskInstance = taskInstanceToAlertTaskInstance;
var t = _interopRequireWildcard(require("io-ts"));
var _pipeable = require("fp-ts/lib/pipeable");
var _Either = require("fp-ts/lib/Either");
var _common = require("../../common");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const enumerateErrorFields = e => `${e.map(({
  context
}) => context.map(({
  key
}) => key).join('.'))}`;
function taskInstanceToAlertTaskInstance(taskInstance, alert) {
  return {
    ...taskInstance,
    params: (0, _pipeable.pipe)(_common.alertParamsSchema.decode(taskInstance.params), (0, _Either.fold)(e => {
      throw new Error(`Task "${taskInstance.id}" ${alert ? `(underlying Alert "${alert.id}") ` : ''}has an invalid param at ${enumerateErrorFields(e)}`);
    }, t.identity)),
    state: (0, _pipeable.pipe)(_common.alertStateSchema.decode(taskInstance.state), (0, _Either.fold)(e => {
      throw new Error(`Task "${taskInstance.id}" ${alert ? `(underlying Alert "${alert.id}") ` : ''}has invalid state at ${enumerateErrorFields(e)}`);
    }, t.identity))
  };
}