"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withTheme = exports.keyframes = exports.euiStyled = exports.css = exports.createGlobalStyle = exports.EuiThemeProviderDecorator = exports.EuiThemeProvider = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var styledComponents = _styledComponents;
var _theme = require("@kbn/ui-shared-deps-src/theme");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const EuiThemeProvider = ({
  darkMode = false,
  ...otherProps
}) => /*#__PURE__*/_react.default.createElement(_styledComponents.ThemeProvider, (0, _extends2.default)({}, otherProps, {
  theme: outerTheme => ({
    ...outerTheme,
    eui: darkMode ? _theme.euiDarkVars : _theme.euiLightVars,
    darkMode
  })
}));

/**
 * Storybook decorator using the EUI theme provider. Uses the value from
 * `globals` provided by the Storybook theme switcher.
 */
exports.EuiThemeProvider = EuiThemeProvider;
const EuiThemeProviderDecorator = (storyFn, {
  globals
}) => {
  const darkMode = globals.euiTheme === 'v8.dark' || globals.euiTheme === 'v7.dark';
  return /*#__PURE__*/_react.default.createElement(EuiThemeProvider, {
    darkMode: darkMode
  }, storyFn());
};
exports.EuiThemeProviderDecorator = EuiThemeProviderDecorator;
const {
  default: euiStyled,
  css,
  createGlobalStyle,
  keyframes,
  withTheme
} = styledComponents;
exports.withTheme = withTheme;
exports.keyframes = keyframes;
exports.createGlobalStyle = createGlobalStyle;
exports.css = css;
exports.euiStyled = euiStyled;