## API Report File for "kibana"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

/// <reference types="node" />

import { AddConfigDeprecation } from '@kbn/config';
import type { ApiResponse } from '@elastic/elasticsearch/lib/Transport';
import Boom from '@hapi/boom';
import { ByteSizeValue } from '@kbn/config-schema';
import { CliArgs } from '@kbn/config';
import { ClientOptions } from '@elastic/elasticsearch';
import { ConditionalType } from '@kbn/config-schema/target_types/types';
import { ConfigDeprecation } from '@kbn/config';
import { ConfigDeprecationContext } from '@kbn/config';
import { ConfigDeprecationFactory } from '@kbn/config';
import { ConfigDeprecationProvider } from '@kbn/config';
import { ConfigPath } from '@kbn/config';
import { ConfigService } from '@kbn/config';
import { DetailedPeerCertificate } from 'tls';
import { Duration } from 'moment';
import { Duration as Duration_2 } from 'moment-timezone';
import { Ecs } from '@kbn/logging';
import { EcsEventCategory } from '@kbn/logging';
import { EcsEventKind } from '@kbn/logging';
import { EcsEventOutcome } from '@kbn/logging';
import { EcsEventType } from '@kbn/logging';
import { EnvironmentMode } from '@kbn/config';
import type { estypes } from '@elastic/elasticsearch';
import { IncomingHttpHeaders } from 'http';
import { inspect } from 'util';
import type { KibanaClient } from '@elastic/elasticsearch/api/kibana';
import { Logger as Logger_2 } from '@kbn/logging';
import { LoggerFactory } from '@kbn/logging';
import { LogLevel as LogLevel_2 } from '@kbn/logging';
import { LogMeta } from '@kbn/logging';
import { LogRecord } from '@kbn/logging';
import type { MaybePromise } from '@kbn/utility-types';
import { ObjectType } from '@kbn/config-schema';
import { Observable } from 'rxjs';
import { PackageInfo } from '@kbn/config';
import { PathConfigType } from '@kbn/utils';
import { PeerCertificate } from 'tls';
import { PublicMethodsOf } from '@kbn/utility-types';
import { Readable } from 'stream';
import { RecursiveReadonly } from '@kbn/utility-types';
import { Request as Request_2 } from '@hapi/hapi';
import type { RequestHandlerContext as RequestHandlerContext_2 } from 'src/core/server';
import { ResponseObject } from '@hapi/hapi';
import { ResponseToolkit } from '@hapi/hapi';
import { SchemaTypeError } from '@kbn/config-schema';
import { ShallowPromise } from '@kbn/utility-types';
import { Stream } from 'stream';
import type { TransportRequestOptions } from '@elastic/elasticsearch/lib/Transport';
import type { TransportRequestParams } from '@elastic/elasticsearch/lib/Transport';
import type { TransportRequestPromise } from '@elastic/elasticsearch/lib/Transport';
import { Type } from '@kbn/config-schema';
import { TypeOf } from '@kbn/config-schema';
import { UiCounterMetricType } from '@kbn/analytics';
import { URL as URL_2 } from 'url';

export { AddConfigDeprecation }

// @public
export const APP_WRAPPER_CLASS = "kbnAppWrapper";

// @public
export interface AppCategory {
    ariaLabel?: string;
    euiIconType?: string;
    id: string;
    label: string;
    order?: number;
}

// Warning: (ae-forgotten-export) The symbol "ConsoleAppenderConfig" needs to be exported by the entry point index.d.ts
// Warning: (ae-forgotten-export) The symbol "FileAppenderConfig" needs to be exported by the entry point index.d.ts
// Warning: (ae-forgotten-export) The symbol "LegacyAppenderConfig" needs to be exported by the entry point index.d.ts
// Warning: (ae-forgotten-export) The symbol "RewriteAppenderConfig" needs to be exported by the entry point index.d.ts
// Warning: (ae-forgotten-export) The symbol "RollingFileAppenderConfig" needs to be exported by the entry point index.d.ts
//
// @public (undocumented)
export type AppenderConfigType = ConsoleAppenderConfig | FileAppenderConfig | LegacyAppenderConfig | RewriteAppenderConfig | RollingFileAppenderConfig;

// @public @deprecated
export interface AsyncPlugin<TSetup = void, TStart = void, TPluginsSetup extends object = object, TPluginsStart extends object = object> {
    // (undocumented)
    setup(core: CoreSetup, plugins: TPluginsSetup): TSetup | Promise<TSetup>;
    // (undocumented)
    start(core: CoreStart, plugins: TPluginsStart): TStart | Promise<TStart>;
    // (undocumented)
    stop?(): void;
}

// @public (undocumented)
export interface Authenticated extends AuthResultParams {
    // (undocumented)
    type: AuthResultType.authenticated;
}

// @public
export type AuthenticationHandler = (request: KibanaRequest, response: LifecycleResponseFactory, toolkit: AuthToolkit) => AuthResult | IKibanaResponse | Promise<AuthResult | IKibanaResponse>;

// @public
export type AuthHeaders = Record<string, string | string[]>;

// @public (undocumented)
export interface AuthNotHandled {
    // (undocumented)
    type: AuthResultType.notHandled;
}

// @public (undocumented)
export interface AuthRedirected extends AuthRedirectedParams {
    // (undocumented)
    type: AuthResultType.redirected;
}

// @public
export interface AuthRedirectedParams {
    headers: {
        location: string;
    } & ResponseHeaders;
}

// @public (undocumented)
export type AuthResult = Authenticated | AuthNotHandled | AuthRedirected;

// @public
export interface AuthResultParams {
    requestHeaders?: AuthHeaders;
    responseHeaders?: AuthHeaders;
    state?: Record<string, any>;
}

// @public (undocumented)
export enum AuthResultType {
    // (undocumented)
    authenticated = "authenticated",
    // (undocumented)
    notHandled = "notHandled",
    // (undocumented)
    redirected = "redirected"
}

// @public
export enum AuthStatus {
    authenticated = "authenticated",
    unauthenticated = "unauthenticated",
    unknown = "unknown"
}

// @public
export interface AuthToolkit {
    authenticated: (data?: AuthResultParams) => AuthResult;
    notHandled: () => AuthResult;
    redirected: (headers: {
        location: string;
    } & ResponseHeaders) => AuthResult;
}

// @public
export interface BaseDeprecationDetails {
    correctiveActions: {
        api?: {
            path: string;
            method: 'POST' | 'PUT';
            body?: {
                [key: string]: any;
            };
            omitContextFromBody?: boolean;
        };
        manualSteps: string[];
    };
    deprecationType?: 'config' | 'feature';
    documentationUrl?: string;
    level: 'warning' | 'critical' | 'fetch_error';
    message: string;
    requireRestart?: boolean;
    title: string;
}

// @public
export class BasePath {
    // @internal
    constructor(serverBasePath?: string, publicBaseUrl?: string);
    get: (request: KibanaRequest) => string;
    prepend: (path: string) => string;
    readonly publicBaseUrl?: string;
    remove: (path: string) => string;
    readonly serverBasePath: string;
    set: (request: KibanaRequest, requestSpecificBasePath: string) => void;
}

// Warning: (ae-forgotten-export) The symbol "BootstrapArgs" needs to be exported by the entry point index.d.ts
//
// @internal (undocumented)
export function bootstrap({ configs, cliArgs, applyConfigOverrides }: BootstrapArgs): Promise<void>;

// @public
export interface Capabilities {
    [key: string]: Record<string, boolean | Record<string, boolean>>;
    catalogue: Record<string, boolean>;
    management: {
        [sectionId: string]: Record<string, boolean>;
    };
    navLinks: Record<string, boolean>;
}

// @public
export type CapabilitiesProvider = () => Partial<Capabilities>;

// @public
export interface CapabilitiesSetup {
    registerProvider(provider: CapabilitiesProvider): void;
    registerSwitcher(switcher: CapabilitiesSwitcher): void;
}

// @public
export interface CapabilitiesStart {
    resolveCapabilities(request: KibanaRequest, options?: ResolveCapabilitiesOptions): Promise<Capabilities>;
}

// @public
export type CapabilitiesSwitcher = (request: KibanaRequest, uiCapabilities: Capabilities, useDefaultCapabilities: boolean) => Partial<Capabilities> | Promise<Partial<Capabilities>>;

// @alpha
export const config: {
    elasticsearch: {
        schema: ObjectType<    {
        sniffOnStart: Type<boolean>;
        sniffInterval: Type<false | Duration>;
        sniffOnConnectionFault: Type<boolean>;
        hosts: Type<string | string[]>;
        username: Type<string | undefined>;
        password: Type<string | undefined>;
        serviceAccountToken: Type<string | undefined>;
        requestHeadersWhitelist: Type<string | string[]>;
        customHeaders: Type<Record<string, string>>;
        shardTimeout: Type<Duration>;
        requestTimeout: Type<Duration>;
        pingTimeout: Type<Duration>;
        logQueries: Type<boolean>;
        ssl: ObjectType<    {
        verificationMode: Type<"none" | "certificate" | "full">;
        certificateAuthorities: Type<string | string[] | undefined>;
        certificate: Type<string | undefined>;
        key: Type<string | undefined>;
        keyPassphrase: Type<string | undefined>;
        keystore: ObjectType<    {
        path: Type<string | undefined>;
        password: Type<string | undefined>;
        }>;
        truststore: ObjectType<    {
        path: Type<string | undefined>;
        password: Type<string | undefined>;
        }>;
        alwaysPresentCertificate: Type<boolean>;
        }>;
        apiVersion: Type<string>;
        healthCheck: ObjectType<    {
        delay: Type<Duration>;
        }>;
        ignoreVersionMismatch: ConditionalType<false, boolean, boolean>;
        skipStartupConnectionCheck: ConditionalType<true, boolean, boolean>;
        }>;
    };
    logging: {
        appenders: Type<AppenderConfigType>;
    };
};

export { ConfigDeprecation }

export { ConfigDeprecationContext }

// @public (undocumented)
export interface ConfigDeprecationDetails extends BaseDeprecationDetails {
    // (undocumented)
    configPath: string;
    // (undocumented)
    deprecationType: 'config';
}

export { ConfigDeprecationFactory }

export { ConfigDeprecationProvider }

export { ConfigPath }

export { ConfigService }

// @internal
export type ConfigUsageData = Record<string, any | any[]>;

// @public
export interface ContextSetup {
    createContextContainer(): IContextContainer;
}

// @internal
export interface CoreConfigUsageData {
    // (undocumented)
    deprecatedKeys: {
        set: string[];
        unset: string[];
    };
    // (undocumented)
    elasticsearch: {
        sniffOnStart: boolean;
        sniffIntervalMs?: number;
        sniffOnConnectionFault: boolean;
        numberOfHostsConfigured: number;
        requestHeadersWhitelistConfigured: boolean;
        customHeadersConfigured: boolean;
        shardTimeoutMs: number;
        requestTimeoutMs: number;
        pingTimeoutMs: number;
        logQueries: boolean;
        ssl: {
            verificationMode: 'none' | 'certificate' | 'full';
            certificateAuthoritiesConfigured: boolean;
            certificateConfigured: boolean;
            keyConfigured: boolean;
            keystoreConfigured: boolean;
            truststoreConfigured: boolean;
            alwaysPresentCertificate: boolean;
        };
        apiVersion: string;
        healthCheckDelayMs: number;
        principal: 'elastic_user' | 'kibana_user' | 'kibana_system_user' | 'other_user' | 'kibana_service_account' | 'unknown';
    };
    // (undocumented)
    http: {
        basePathConfigured: boolean;
        maxPayloadInBytes: number;
        rewriteBasePath: boolean;
        keepaliveTimeout: number;
        socketTimeout: number;
        compression: {
            enabled: boolean;
            referrerWhitelistConfigured: boolean;
        };
        xsrf: {
            disableProtection: boolean;
            allowlistConfigured: boolean;
        };
        requestId: {
            allowFromAnyIp: boolean;
            ipAllowlistConfigured: boolean;
        };
        ssl: {
            certificateAuthoritiesConfigured: boolean;
            certificateConfigured: boolean;
            cipherSuites: string[];
            keyConfigured: boolean;
            keystoreConfigured: boolean;
            truststoreConfigured: boolean;
            redirectHttpFromPortConfigured: boolean;
            supportedProtocols: string[];
            clientAuthentication: 'none' | 'optional' | 'required';
        };
        securityResponseHeaders: {
            strictTransportSecurity: string;
            xContentTypeOptions: string;
            referrerPolicy: string;
            permissionsPolicyConfigured: boolean;
            disableEmbedding: boolean;
        };
    };
    // (undocumented)
    logging: {
        appendersTypesUsed: string[];
        loggersConfiguredCount: number;
    };
    // (undocumented)
    savedObjects: {
        customIndex: boolean;
        maxImportPayloadBytes: number;
        maxImportExportSize: number;
    };
}

// @internal
export interface CoreEnvironmentUsageData {
    // (undocumented)
    memory: {
        heapTotalBytes: number;
        heapUsedBytes: number;
        heapSizeLimit: number;
    };
}

// @internal (undocumented)
export type CoreId = symbol;

// @public
export interface CorePreboot {
    // (undocumented)
    elasticsearch: ElasticsearchServicePreboot;
    // (undocumented)
    http: HttpServicePreboot;
    // (undocumented)
    preboot: PrebootServicePreboot;
}

// @internal
export interface CoreServicesUsageData {
    // (undocumented)
    savedObjects: {
        indices: {
            alias: string;
            docsCount: number;
            docsDeleted: number;
            storeSizeBytes: number;
            primaryStoreSizeBytes: number;
            savedObjectsDocsCount: number;
        }[];
        legacyUrlAliases: {
            activeCount: number;
            inactiveCount: number;
            disabledCount: number;
            totalCount: number;
        };
    };
}

// @public
export interface CoreSetup<TPluginsStart extends object = object, TStart = unknown> {
    // (undocumented)
    capabilities: CapabilitiesSetup;
    // (undocumented)
    context: ContextSetup;
    // (undocumented)
    deprecations: DeprecationsServiceSetup;
    // (undocumented)
    elasticsearch: ElasticsearchServiceSetup;
    // (undocumented)
    executionContext: ExecutionContextSetup;
    // (undocumented)
    getStartServices: StartServicesAccessor<TPluginsStart, TStart>;
    // (undocumented)
    http: HttpServiceSetup & {
        resources: HttpResources;
    };
    // (undocumented)
    i18n: I18nServiceSetup;
    // (undocumented)
    logging: LoggingServiceSetup;
    // (undocumented)
    metrics: MetricsServiceSetup;
    // (undocumented)
    savedObjects: SavedObjectsServiceSetup;
    // (undocumented)
    status: StatusServiceSetup;
    // (undocumented)
    uiSettings: UiSettingsServiceSetup;
}

// @public
export interface CoreStart {
    // (undocumented)
    capabilities: CapabilitiesStart;
    // @internal (undocumented)
    coreUsageData: CoreUsageDataStart;
    // (undocumented)
    elasticsearch: ElasticsearchServiceStart;
    // (undocumented)
    executionContext: ExecutionContextStart;
    // (undocumented)
    http: HttpServiceStart;
    // (undocumented)
    metrics: MetricsServiceStart;
    // (undocumented)
    savedObjects: SavedObjectsServiceStart;
    // (undocumented)
    uiSettings: UiSettingsServiceStart;
}

// @public
export interface CoreStatus {
    // (undocumented)
    elasticsearch: ServiceStatus;
    // (undocumented)
    savedObjects: ServiceStatus;
}

// @internal
export interface CoreUsageData extends CoreUsageStats {
    // (undocumented)
    config: CoreConfigUsageData;
    // (undocumented)
    environment: CoreEnvironmentUsageData;
    // (undocumented)
    services: CoreServicesUsageData;
}

// @internal
export interface CoreUsageDataStart {
    // (undocumented)
    getConfigsUsageData(): Promise<ConfigUsageData>;
    getCoreUsageData(): Promise<CoreUsageData>;
}

// @internal
export interface CoreUsageStats {
    // (undocumented)
    'apiCalls.legacyDashboardExport.namespace.custom.kibanaRequest.no'?: number;
    // (undocumented)
    'apiCalls.legacyDashboardExport.namespace.custom.kibanaRequest.yes'?: number;
    // (undocumented)
    'apiCalls.legacyDashboardExport.namespace.custom.total'?: number;
    // (undocumented)
    'apiCalls.legacyDashboardExport.namespace.default.kibanaRequest.no'?: number;
    // (undocumented)
    'apiCalls.legacyDashboardExport.namespace.default.kibanaRequest.yes'?: number;
    // (undocumented)
    'apiCalls.legacyDashboardExport.namespace.default.total'?: number;
    // (undocumented)
    'apiCalls.legacyDashboardExport.total'?: number;
    // (undocumented)
    'apiCalls.legacyDashboardImport.namespace.custom.kibanaRequest.no'?: number;
    // (undocumented)
    'apiCalls.legacyDashboardImport.namespace.custom.kibanaRequest.yes'?: number;
    // (undocumented)
    'apiCalls.legacyDashboardImport.namespace.custom.total'?: number;
    // (undocumented)
    'apiCalls.legacyDashboardImport.namespace.default.kibanaRequest.no'?: number;
    // (undocumented)
    'apiCalls.legacyDashboardImport.namespace.default.kibanaRequest.yes'?: number;
    // (undocumented)
    'apiCalls.legacyDashboardImport.namespace.default.total'?: number;
    // (undocumented)
    'apiCalls.legacyDashboardImport.total'?: number;
    // (undocumented)
    'apiCalls.savedObjectsBulkCreate.namespace.custom.kibanaRequest.no'?: number;
    // (undocumented)
    'apiCalls.savedObjectsBulkCreate.namespace.custom.kibanaRequest.yes'?: number;
    // (undocumented)
    'apiCalls.savedObjectsBulkCreate.namespace.custom.total'?: number;
    // (undocumented)
    'apiCalls.savedObjectsBulkCreate.namespace.default.kibanaRequest.no'?: number;
    // (undocumented)
    'apiCalls.savedObjectsBulkCreate.namespace.default.kibanaRequest.yes'?: number;
    // (undocumented)
    'apiCalls.savedObjectsBulkCreate.namespace.default.total'?: number;
    // (undocumented)
    'apiCalls.savedObjectsBulkCreate.total'?: number;
    // (undocumented)
    'apiCalls.savedObjectsBulkGet.namespace.custom.kibanaRequest.no'?: number;
    // (undocumented)
    'apiCalls.savedObjectsBulkGet.namespace.custom.kibanaRequest.yes'?: number;
    // (undocumented)
    'apiCalls.savedObjectsBulkGet.namespace.custom.total'?: number;
    // (undocumented)
    'apiCalls.savedObjectsBulkGet.namespace.default.kibanaRequest.no'?: number;
    // (undocumented)
    'apiCalls.savedObjectsBulkGet.namespace.default.kibanaRequest.yes'?: number;
    // (undocumented)
    'apiCalls.savedObjectsBulkGet.namespace.default.total'?: number;
    // (undocumented)
    'apiCalls.savedObjectsBulkGet.total'?: number;
    // (undocumented)
    'apiCalls.savedObjectsBulkResolve.namespace.custom.kibanaRequest.no'?: number;
    // (undocumented)
    'apiCalls.savedObjectsBulkResolve.namespace.custom.kibanaRequest.yes'?: number;
    // (undocumented)
    'apiCalls.savedObjectsBulkResolve.namespace.custom.total'?: number;
    // (undocumented)
    'apiCalls.savedObjectsBulkResolve.namespace.default.kibanaRequest.no'?: number;
    // (undocumented)
    'apiCalls.savedObjectsBulkResolve.namespace.default.kibanaRequest.yes'?: number;
    // (undocumented)
    'apiCalls.savedObjectsBulkResolve.namespace.default.total'?: number;
    // (undocumented)
    'apiCalls.savedObjectsBulkResolve.total'?: number;
    // (undocumented)
    'apiCalls.savedObjectsBulkUpdate.namespace.custom.kibanaRequest.no'?: number;
    // (undocumented)
    'apiCalls.savedObjectsBulkUpdate.namespace.custom.kibanaRequest.yes'?: number;
    // (undocumented)
    'apiCalls.savedObjectsBulkUpdate.namespace.custom.total'?: number;
    // (undocumented)
    'apiCalls.savedObjectsBulkUpdate.namespace.default.kibanaRequest.no'?: number;
    // (undocumented)
    'apiCalls.savedObjectsBulkUpdate.namespace.default.kibanaRequest.yes'?: number;
    // (undocumented)
    'apiCalls.savedObjectsBulkUpdate.namespace.default.total'?: number;
    // (undocumented)
    'apiCalls.savedObjectsBulkUpdate.total'?: number;
    // (undocumented)
    'apiCalls.savedObjectsCreate.namespace.custom.kibanaRequest.no'?: number;
    // (undocumented)
    'apiCalls.savedObjectsCreate.namespace.custom.kibanaRequest.yes'?: number;
    // (undocumented)
    'apiCalls.savedObjectsCreate.namespace.custom.total'?: number;
    // (undocumented)
    'apiCalls.savedObjectsCreate.namespace.default.kibanaRequest.no'?: number;
    // (undocumented)
    'apiCalls.savedObjectsCreate.namespace.default.kibanaRequest.yes'?: number;
    // (undocumented)
    'apiCalls.savedObjectsCreate.namespace.default.total'?: number;
    // (undocumented)
    'apiCalls.savedObjectsCreate.total'?: number;
    // (undocumented)
    'apiCalls.savedObjectsDelete.namespace.custom.kibanaRequest.no'?: number;
    // (undocumented)
    'apiCalls.savedObjectsDelete.namespace.custom.kibanaRequest.yes'?: number;
    // (undocumented)
    'apiCalls.savedObjectsDelete.namespace.custom.total'?: number;
    // (undocumented)
    'apiCalls.savedObjectsDelete.namespace.default.kibanaRequest.no'?: number;
    // (undocumented)
    'apiCalls.savedObjectsDelete.namespace.default.kibanaRequest.yes'?: number;
    // (undocumented)
    'apiCalls.savedObjectsDelete.namespace.default.total'?: number;
    // (undocumented)
    'apiCalls.savedObjectsDelete.total'?: number;
    // (undocumented)
    'apiCalls.savedObjectsExport.allTypesSelected.no'?: number;
    // (undocumented)
    'apiCalls.savedObjectsExport.allTypesSelected.yes'?: number;
    // (undocumented)
    'apiCalls.savedObjectsExport.namespace.custom.kibanaRequest.no'?: number;
    // (undocumented)
    'apiCalls.savedObjectsExport.namespace.custom.kibanaRequest.yes'?: number;
    // (undocumented)
    'apiCalls.savedObjectsExport.namespace.custom.total'?: number;
    // (undocumented)
    'apiCalls.savedObjectsExport.namespace.default.kibanaRequest.no'?: number;
    // (undocumented)
    'apiCalls.savedObjectsExport.namespace.default.kibanaRequest.yes'?: number;
    // (undocumented)
    'apiCalls.savedObjectsExport.namespace.default.total'?: number;
    // (undocumented)
    'apiCalls.savedObjectsExport.total'?: number;
    // (undocumented)
    'apiCalls.savedObjectsFind.namespace.custom.kibanaRequest.no'?: number;
    // (undocumented)
    'apiCalls.savedObjectsFind.namespace.custom.kibanaRequest.yes'?: number;
    // (undocumented)
    'apiCalls.savedObjectsFind.namespace.custom.total'?: number;
    // (undocumented)
    'apiCalls.savedObjectsFind.namespace.default.kibanaRequest.no'?: number;
    // (undocumented)
    'apiCalls.savedObjectsFind.namespace.default.kibanaRequest.yes'?: number;
    // (undocumented)
    'apiCalls.savedObjectsFind.namespace.default.total'?: number;
    // (undocumented)
    'apiCalls.savedObjectsFind.total'?: number;
    // (undocumented)
    'apiCalls.savedObjectsGet.namespace.custom.kibanaRequest.no'?: number;
    // (undocumented)
    'apiCalls.savedObjectsGet.namespace.custom.kibanaRequest.yes'?: number;
    // (undocumented)
    'apiCalls.savedObjectsGet.namespace.custom.total'?: number;
    // (undocumented)
    'apiCalls.savedObjectsGet.namespace.default.kibanaRequest.no'?: number;
    // (undocumented)
    'apiCalls.savedObjectsGet.namespace.default.kibanaRequest.yes'?: number;
    // (undocumented)
    'apiCalls.savedObjectsGet.namespace.default.total'?: number;
    // (undocumented)
    'apiCalls.savedObjectsGet.total'?: number;
    // (undocumented)
    'apiCalls.savedObjectsImport.createNewCopiesEnabled.no'?: number;
    // (undocumented)
    'apiCalls.savedObjectsImport.createNewCopiesEnabled.yes'?: number;
    // (undocumented)
    'apiCalls.savedObjectsImport.namespace.custom.kibanaRequest.no'?: number;
    // (undocumented)
    'apiCalls.savedObjectsImport.namespace.custom.kibanaRequest.yes'?: number;
    // (undocumented)
    'apiCalls.savedObjectsImport.namespace.custom.total'?: number;
    // (undocumented)
    'apiCalls.savedObjectsImport.namespace.default.kibanaRequest.no'?: number;
    // (undocumented)
    'apiCalls.savedObjectsImport.namespace.default.kibanaRequest.yes'?: number;
    // (undocumented)
    'apiCalls.savedObjectsImport.namespace.default.total'?: number;
    // (undocumented)
    'apiCalls.savedObjectsImport.overwriteEnabled.no'?: number;
    // (undocumented)
    'apiCalls.savedObjectsImport.overwriteEnabled.yes'?: number;
    // (undocumented)
    'apiCalls.savedObjectsImport.total'?: number;
    // (undocumented)
    'apiCalls.savedObjectsResolve.namespace.custom.kibanaRequest.no'?: number;
    // (undocumented)
    'apiCalls.savedObjectsResolve.namespace.custom.kibanaRequest.yes'?: number;
    // (undocumented)
    'apiCalls.savedObjectsResolve.namespace.custom.total'?: number;
    // (undocumented)
    'apiCalls.savedObjectsResolve.namespace.default.kibanaRequest.no'?: number;
    // (undocumented)
    'apiCalls.savedObjectsResolve.namespace.default.kibanaRequest.yes'?: number;
    // (undocumented)
    'apiCalls.savedObjectsResolve.namespace.default.total'?: number;
    // (undocumented)
    'apiCalls.savedObjectsResolve.total'?: number;
    // (undocumented)
    'apiCalls.savedObjectsResolveImportErrors.createNewCopiesEnabled.no'?: number;
    // (undocumented)
    'apiCalls.savedObjectsResolveImportErrors.createNewCopiesEnabled.yes'?: number;
    // (undocumented)
    'apiCalls.savedObjectsResolveImportErrors.namespace.custom.kibanaRequest.no'?: number;
    // (undocumented)
    'apiCalls.savedObjectsResolveImportErrors.namespace.custom.kibanaRequest.yes'?: number;
    // (undocumented)
    'apiCalls.savedObjectsResolveImportErrors.namespace.custom.total'?: number;
    // (undocumented)
    'apiCalls.savedObjectsResolveImportErrors.namespace.default.kibanaRequest.no'?: number;
    // (undocumented)
    'apiCalls.savedObjectsResolveImportErrors.namespace.default.kibanaRequest.yes'?: number;
    // (undocumented)
    'apiCalls.savedObjectsResolveImportErrors.namespace.default.total'?: number;
    // (undocumented)
    'apiCalls.savedObjectsResolveImportErrors.total'?: number;
    // (undocumented)
    'apiCalls.savedObjectsUpdate.namespace.custom.kibanaRequest.no'?: number;
    // (undocumented)
    'apiCalls.savedObjectsUpdate.namespace.custom.kibanaRequest.yes'?: number;
    // (undocumented)
    'apiCalls.savedObjectsUpdate.namespace.custom.total'?: number;
    // (undocumented)
    'apiCalls.savedObjectsUpdate.namespace.default.kibanaRequest.no'?: number;
    // (undocumented)
    'apiCalls.savedObjectsUpdate.namespace.default.kibanaRequest.yes'?: number;
    // (undocumented)
    'apiCalls.savedObjectsUpdate.namespace.default.total'?: number;
    // (undocumented)
    'apiCalls.savedObjectsUpdate.total'?: number;
    // (undocumented)
    'savedObjectsRepository.resolvedOutcome.aliasMatch'?: number;
    // (undocumented)
    'savedObjectsRepository.resolvedOutcome.conflict'?: number;
    // (undocumented)
    'savedObjectsRepository.resolvedOutcome.exactMatch'?: number;
    // (undocumented)
    'savedObjectsRepository.resolvedOutcome.notFound'?: number;
    // (undocumented)
    'savedObjectsRepository.resolvedOutcome.total'?: number;
}

// @public (undocumented)
export interface CountResponse {
    // (undocumented)
    count: number;
    // (undocumented)
    _shards: ShardsInfo;
}

// @public
export class CspConfig implements ICspConfig {
    // Warning: (ae-forgotten-export) The symbol "CspConfigType" needs to be exported by the entry point index.d.ts
    //
    // @internal
    constructor(rawCspConfig: CspConfigType);
    // (undocumented)
    static readonly DEFAULT: CspConfig;
    // (undocumented)
    readonly disableEmbedding: boolean;
    // (undocumented)
    readonly header: string;
    // (undocumented)
    readonly rules: string[];
    // (undocumented)
    readonly strict: boolean;
    // (undocumented)
    readonly warnLegacyBrowsers: boolean;
}

// @public
export interface CustomHttpResponseOptions<T extends HttpResponsePayload | ResponseError> {
    body?: T;
    bypassErrorFormat?: boolean;
    headers?: ResponseHeaders;
    // (undocumented)
    statusCode: number;
}

// @internal (undocumented)
export const DEFAULT_APP_CATEGORIES: Record<string, AppCategory>;

// @public (undocumented)
export interface DeleteDocumentResponse {
    // (undocumented)
    error?: {
        type: string;
    };
    // (undocumented)
    found: boolean;
    // (undocumented)
    _id: string;
    // (undocumented)
    _index: string;
    // (undocumented)
    result: string;
    // (undocumented)
    _shards: ShardsResponse;
    // (undocumented)
    _type: string;
    // (undocumented)
    _version: number;
}

// @public
export interface DeprecationsClient {
    // Warning: (ae-forgotten-export) The symbol "DomainDeprecationDetails" needs to be exported by the entry point index.d.ts
    //
    // (undocumented)
    getAllDeprecations: () => Promise<DomainDeprecationDetails[]>;
}

// @public (undocumented)
export type DeprecationsDetails = ConfigDeprecationDetails | FeatureDeprecationDetails;

// @public
export interface DeprecationSettings {
    docLinksKey: string;
    message: string;
}

// @public
export interface DeprecationsServiceSetup {
    // (undocumented)
    registerDeprecations: (deprecationContext: RegisterDeprecationsConfig) => void;
}

// @public
export type DestructiveRouteMethod = 'post' | 'put' | 'delete' | 'patch';

// @public
export interface DiscoveredPlugin {
    readonly configPath: ConfigPath;
    readonly enabledOnAnonymousPages?: boolean;
    readonly id: PluginName;
    readonly optionalPlugins: readonly PluginName[];
    readonly requiredBundles: readonly PluginName[];
    readonly requiredPlugins: readonly PluginName[];
    readonly type: PluginType;
}

export { Ecs }

export { EcsEventCategory }

export { EcsEventKind }

export { EcsEventOutcome }

export { EcsEventType }

// @public
export type ElasticsearchClient = Omit<KibanaClient, 'connectionPool' | 'transport' | 'serializer' | 'extend' | 'child' | 'close'> & {
    transport: {
        request(params: TransportRequestParams, options?: TransportRequestOptions): TransportRequestPromise<ApiResponse>;
    };
};

// @public
export type ElasticsearchClientConfig = Pick<ElasticsearchConfig, 'customHeaders' | 'sniffOnStart' | 'sniffOnConnectionFault' | 'requestHeadersWhitelist' | 'sniffInterval' | 'hosts' | 'username' | 'password' | 'serviceAccountToken'> & {
    pingTimeout?: ElasticsearchConfig['pingTimeout'] | ClientOptions['pingTimeout'];
    requestTimeout?: ElasticsearchConfig['requestTimeout'] | ClientOptions['requestTimeout'];
    ssl?: Partial<ElasticsearchConfig['ssl']>;
    keepAlive?: boolean;
    caFingerprint?: ClientOptions['caFingerprint'];
};

// @public
export class ElasticsearchConfig {
    constructor(rawConfig: ElasticsearchConfigType);
    readonly apiVersion: string;
    // Warning: (ae-forgotten-export) The symbol "ElasticsearchConfigType" needs to be exported by the entry point index.d.ts
    readonly customHeaders: ElasticsearchConfigType['customHeaders'];
    readonly healthCheckDelay: Duration;
    readonly hosts: string[];
    readonly ignoreVersionMismatch: boolean;
    readonly password?: string;
    readonly pingTimeout: Duration;
    readonly requestHeadersWhitelist: string[];
    readonly requestTimeout: Duration;
    readonly serviceAccountToken?: string;
    readonly shardTimeout: Duration;
    // @internal
    readonly skipStartupConnectionCheck: boolean;
    readonly sniffInterval: false | Duration;
    readonly sniffOnConnectionFault: boolean;
    readonly sniffOnStart: boolean;
    // Warning: (ae-forgotten-export) The symbol "SslConfigSchema" needs to be exported by the entry point index.d.ts
    readonly ssl: Pick<SslConfigSchema, Exclude<keyof SslConfigSchema, 'certificateAuthorities' | 'keystore' | 'truststore'>> & {
        certificateAuthorities?: string[];
    };
    readonly username?: string;
}

// @public
export interface ElasticsearchConfigPreboot {
    readonly credentialsSpecified: boolean;
    readonly hosts: string[];
}

// @public (undocumented)
export interface ElasticsearchServicePreboot {
    readonly config: Readonly<ElasticsearchConfigPreboot>;
    readonly createClient: (type: string, clientConfig?: Partial<ElasticsearchClientConfig>) => ICustomClusterClient;
}

// @public (undocumented)
export interface ElasticsearchServiceSetup {
    // @deprecated (undocumented)
    legacy: {
        readonly config$: Observable<ElasticsearchConfig>;
    };
}

// @public (undocumented)
export interface ElasticsearchServiceStart {
    readonly client: IClusterClient;
    readonly createClient: (type: string, clientConfig?: Partial<ElasticsearchClientConfig>) => ICustomClusterClient;
    // @deprecated (undocumented)
    legacy: {
        readonly config$: Observable<ElasticsearchConfig>;
    };
}

// @public (undocumented)
export interface ElasticsearchStatusMeta {
    // (undocumented)
    incompatibleNodes: NodesVersionCompatibility['incompatibleNodes'];
    // (undocumented)
    nodesInfoRequestError?: NodesVersionCompatibility['nodesInfoRequestError'];
    // (undocumented)
    warningNodes: NodesVersionCompatibility['warningNodes'];
}

export { EnvironmentMode }

// @public
export interface ErrorHttpResponseOptions {
    body?: ResponseError;
    headers?: ResponseHeaders;
}

// Warning: (ae-missing-release-tag) "EventLoopDelaysMonitor" is part of the package's API, but it is missing a release tag (@alpha, @beta, @public, or @internal)
//
// @public (undocumented)
export class EventLoopDelaysMonitor {
    constructor();
    collect(): IntervalHistogram;
    reset(): void;
    stop(): void;
}

// @public (undocumented)
export interface ExecutionContextSetup {
    withContext<R>(context: KibanaExecutionContext | undefined, fn: (...args: any[]) => R): R;
}

// @public (undocumented)
export type ExecutionContextStart = ExecutionContextSetup;

// Warning: (ae-forgotten-export) The symbol "Maybe" needs to be exported by the entry point index.d.ts
//
// @public
export type ExposedToBrowserDescriptor<T> = {
    [Key in keyof T]?: T[Key] extends Maybe<any[]> ? boolean : T[Key] extends Maybe<object> ? // can be nested for objects
    ExposedToBrowserDescriptor<T[Key]> | boolean : boolean;
};

// @public
export interface FakeRequest {
    headers: Headers_2;
}

// @public (undocumented)
export interface FeatureDeprecationDetails extends BaseDeprecationDetails {
    // (undocumented)
    deprecationType?: 'feature' | undefined;
}

// @public
export type GetAuthHeaders = (request: KibanaRequest) => AuthHeaders | undefined;

// @public
export type GetAuthState = <T = unknown>(request: KibanaRequest) => {
    status: AuthStatus;
    state: T;
};

// @public (undocumented)
export interface GetDeprecationsContext {
    // (undocumented)
    esClient: IScopedClusterClient;
    // (undocumented)
    savedObjectsClient: SavedObjectsClientContract;
}

// @public (undocumented)
export interface GetResponse<T> {
    // (undocumented)
    found: boolean;
    // (undocumented)
    _id: string;
    // (undocumented)
    _index: string;
    // (undocumented)
    _primary_term: number;
    // (undocumented)
    _routing?: string;
    // (undocumented)
    _seq_no: number;
    // (undocumented)
    _source: T;
    // (undocumented)
    _type: string;
    // (undocumented)
    _version: number;
}

// @public
export type HandlerContextType<T extends HandlerFunction<any>> = T extends HandlerFunction<infer U> ? U : never;

// @public
export type HandlerFunction<T extends object> = (context: T, ...args: any[]) => any;

// @public
export type HandlerParameters<T extends HandlerFunction<any>> = T extends (context: any, ...args: infer U) => any ? U : never;

// @public
type Headers_2 = {
    [header in KnownHeaders]?: string | string[] | undefined;
} & {
    [header: string]: string | string[] | undefined;
};
export { Headers_2 as Headers }

// @public (undocumented)
export interface HttpAuth {
    get: GetAuthState;
    isAuthenticated: IsAuthenticated;
}

// @public
export interface HttpResources {
    register: <P, Q, B, Context extends RequestHandlerContext_2 = RequestHandlerContext_2>(route: RouteConfig<P, Q, B, 'get'>, handler: HttpResourcesRequestHandler<P, Q, B, Context>) => void;
}

// @public
export interface HttpResourcesRenderOptions {
    headers?: ResponseHeaders;
    // @internal
    includeExposedConfigKeys?: boolean;
}

// @public
export type HttpResourcesRequestHandler<P = unknown, Q = unknown, B = unknown, Context extends RequestHandlerContext_2 = RequestHandlerContext_2> = RequestHandler<P, Q, B, Context, 'get', KibanaResponseFactory & HttpResourcesServiceToolkit>;

// @public
export type HttpResourcesResponseOptions = HttpResponseOptions;

// @public
export interface HttpResourcesServiceToolkit {
    renderAnonymousCoreApp: (options?: HttpResourcesRenderOptions) => Promise<IKibanaResponse>;
    renderCoreApp: (options?: HttpResourcesRenderOptions) => Promise<IKibanaResponse>;
    renderHtml: (options: HttpResourcesResponseOptions) => IKibanaResponse;
    renderJs: (options: HttpResourcesResponseOptions) => IKibanaResponse;
}

// @public
export interface HttpResponseOptions {
    body?: HttpResponsePayload;
    bypassErrorFormat?: boolean;
    headers?: ResponseHeaders;
}

// @public
export type HttpResponsePayload = undefined | string | Record<string, any> | Buffer | Stream;

// @public
export interface HttpServerInfo {
    hostname: string;
    name: string;
    port: number;
    protocol: 'http' | 'https' | 'socket';
}

// @public
export interface HttpServicePreboot {
    basePath: IBasePath;
    getServerInfo: () => HttpServerInfo;
    registerRoutes(path: string, callback: (router: IRouter) => void): void;
}

// @public
export interface HttpServiceSetup {
    // @deprecated
    auth: HttpAuth;
    basePath: IBasePath;
    createCookieSessionStorageFactory: <T>(cookieOptions: SessionStorageCookieOptions<T>) => Promise<SessionStorageFactory<T>>;
    createRouter: <Context extends RequestHandlerContext = RequestHandlerContext>() => IRouter<Context>;
    csp: ICspConfig;
    getServerInfo: () => HttpServerInfo;
    registerAuth: (handler: AuthenticationHandler) => void;
    registerOnPostAuth: (handler: OnPostAuthHandler) => void;
    registerOnPreAuth: (handler: OnPreAuthHandler) => void;
    registerOnPreResponse: (handler: OnPreResponseHandler) => void;
    registerOnPreRouting: (handler: OnPreRoutingHandler) => void;
    registerRouteHandlerContext: <Context extends RequestHandlerContext, ContextName extends keyof Context>(contextName: ContextName, provider: RequestHandlerContextProvider<Context, ContextName>) => RequestHandlerContextContainer;
}

// @public (undocumented)
export interface HttpServiceStart {
    auth: HttpAuth;
    basePath: IBasePath;
    getServerInfo: () => HttpServerInfo;
}

// @public (undocumented)
export interface I18nServiceSetup {
    getLocale(): string;
    getTranslationFiles(): string[];
}

// @public
export type IBasePath = Pick<BasePath, keyof BasePath>;

// @public
export interface IClusterClient {
    readonly asInternalUser: ElasticsearchClient;
    asScoped: (request: ScopeableRequest) => IScopedClusterClient;
}

// @public
export interface IContextContainer {
    createHandler(pluginOpaqueId: PluginOpaqueId, handler: RequestHandler): (...rest: HandlerParameters<RequestHandler>) => ShallowPromise<ReturnType<RequestHandler>>;
    registerContext<Context extends RequestHandlerContext, ContextName extends keyof Context>(pluginOpaqueId: PluginOpaqueId, contextName: ContextName, provider: IContextProvider<Context, ContextName>): this;
}

// @public
export type IContextProvider<Context extends RequestHandlerContext, ContextName extends keyof Context> = (context: Omit<Context, ContextName>, ...rest: HandlerParameters<RequestHandler>) => Promise<Context[ContextName]> | Context[ContextName];

// @public
export interface ICspConfig {
    readonly disableEmbedding: boolean;
    readonly header: string;
    readonly rules: string[];
    readonly strict: boolean;
    readonly warnLegacyBrowsers: boolean;
}

// @public
export interface ICustomClusterClient extends IClusterClient {
    close: () => Promise<void>;
}

// @public (undocumented)
export interface IExecutionContextContainer {
    // (undocumented)
    toJSON(): Readonly<KibanaExecutionContext>;
    // (undocumented)
    toString(): string;
}

// @public
export interface IExternalUrlConfig {
    readonly policy: IExternalUrlPolicy[];
}

// @public
export interface IExternalUrlPolicy {
    allow: boolean;
    host?: string;
    protocol?: string;
}

// @public
export interface IKibanaResponse<T extends HttpResponsePayload | ResponseError = any> {
    // (undocumented)
    readonly options: HttpResponseOptions;
    // (undocumented)
    readonly payload?: T;
    // (undocumented)
    readonly status: number;
}

// @public
export interface IKibanaSocket {
    readonly authorizationError?: Error;
    readonly authorized?: boolean;
    // (undocumented)
    getPeerCertificate(detailed: true): DetailedPeerCertificate | null;
    // (undocumented)
    getPeerCertificate(detailed: false): PeerCertificate | null;
    getPeerCertificate(detailed?: boolean): PeerCertificate | DetailedPeerCertificate | null;
    getProtocol(): string | null;
    renegotiate(options: {
        rejectUnauthorized?: boolean;
        requestCert?: boolean;
    }): Promise<void>;
}

// @public
export interface IntervalHistogram {
    // (undocumented)
    exceeds: number;
    // (undocumented)
    fromTimestamp: string;
    // (undocumented)
    lastUpdatedAt: string;
    // (undocumented)
    max: number;
    // (undocumented)
    mean: number;
    // (undocumented)
    min: number;
    // (undocumented)
    percentiles: {
        50: number;
        75: number;
        95: number;
        99: number;
    };
    // (undocumented)
    stddev: number;
}

// @public (undocumented)
export interface IRenderOptions {
    // @internal
    includeExposedConfigKeys?: boolean;
    isAnonymousPage?: boolean;
    // @internal @deprecated
    vars?: Record<string, any>;
}

// @public
export interface IRouter<Context extends RequestHandlerContext = RequestHandlerContext> {
    delete: RouteRegistrar<'delete', Context>;
    get: RouteRegistrar<'get', Context>;
    // Warning: (ae-forgotten-export) The symbol "RouterRoute" needs to be exported by the entry point index.d.ts
    //
    // @internal
    getRoutes: () => RouterRoute[];
    handleLegacyErrors: RequestHandlerWrapper;
    patch: RouteRegistrar<'patch', Context>;
    post: RouteRegistrar<'post', Context>;
    put: RouteRegistrar<'put', Context>;
    routerPath: string;
}

// @public
export type IsAuthenticated = (request: KibanaRequest) => boolean;

// @public (undocumented)
export type ISavedObjectsExporter = PublicMethodsOf<SavedObjectsExporter>;

// @public (undocumented)
export type ISavedObjectsImporter = PublicMethodsOf<SavedObjectsImporter>;

// @public (undocumented)
export interface ISavedObjectsPointInTimeFinder<T, A> {
    close: () => Promise<void>;
    find: () => AsyncGenerator<SavedObjectsFindResponse<T, A>>;
}

// @public
export type ISavedObjectsRepository = Pick<SavedObjectsRepository, keyof SavedObjectsRepository>;

// @public
export type ISavedObjectTypeRegistry = Omit<SavedObjectTypeRegistry, 'registerType'>;

// @public
export interface IScopedClusterClient {
    readonly asCurrentUser: ElasticsearchClient;
    readonly asInternalUser: ElasticsearchClient;
}

// @public
export interface IUiSettingsClient {
    get: <T = any>(key: string) => Promise<T>;
    getAll: <T = any>() => Promise<Record<string, T>>;
    getRegistered: () => Readonly<Record<string, PublicUiSettingsParams>>;
    getUserProvided: <T = any>() => Promise<Record<string, UserProvidedValues<T>>>;
    isOverridden: (key: string) => boolean;
    isSensitive: (key: string) => boolean;
    remove: (key: string) => Promise<void>;
    removeMany: (keys: string[]) => Promise<void>;
    set: (key: string, value: any) => Promise<void>;
    setMany: (changes: Record<string, any>) => Promise<void>;
}

// @public
export type KibanaExecutionContext = {
    readonly type: string;
    readonly name: string;
    readonly id: string;
    readonly description: string;
    readonly url?: string;
    parent?: KibanaExecutionContext;
};

// @public
export class KibanaRequest<Params = unknown, Query = unknown, Body = unknown, Method extends RouteMethod = any> {
    // (undocumented)
    [inspect.custom](): {
        id: string;
        uuid: string;
        url: string;
        isSystemRequest: boolean;
        auth: {
            isAuthenticated: boolean;
        };
        route: Readonly<{
            path: string;
            method: RecursiveReadonly<Method>;
            options: RecursiveReadonly<KibanaRequestRouteOptions<Method>>;
        }>;
    };
    // @internal (undocumented)
    protected readonly [requestSymbol]: Request_2;
    constructor(request: Request_2, params: Params, query: Query, body: Body, withoutSecretHeaders: boolean);
    // (undocumented)
    readonly auth: {
        isAuthenticated: boolean;
    };
    // (undocumented)
    readonly body: Body;
    readonly events: KibanaRequestEvents;
    // Warning: (ae-forgotten-export) The symbol "RouteValidator" needs to be exported by the entry point index.d.ts
    //
    // @internal
    static from<P, Q, B>(req: Request_2, routeSchemas?: RouteValidator<P, Q, B> | RouteValidatorFullConfig<P, Q, B>, withoutSecretHeaders?: boolean): KibanaRequest<P, Q, B, any>;
    readonly headers: Headers_2;
    readonly id: string;
    readonly isSystemRequest: boolean;
    // (undocumented)
    readonly params: Params;
    // (undocumented)
    readonly query: Query;
    readonly rewrittenUrl?: URL_2;
    readonly route: RecursiveReadonly<KibanaRequestRoute<Method>>;
    // (undocumented)
    readonly socket: IKibanaSocket;
    // (undocumented)
    toJSON(): {
        id: string;
        uuid: string;
        url: string;
        isSystemRequest: boolean;
        auth: {
            isAuthenticated: boolean;
        };
        route: Readonly<{
            path: string;
            method: RecursiveReadonly<Method>;
            options: RecursiveReadonly<KibanaRequestRouteOptions<Method>>;
        }>;
    };
    // (undocumented)
    toString(): string;
    readonly url: URL_2;
    readonly uuid: string;
}

// @public
export interface KibanaRequestEvents {
    aborted$: Observable<void>;
    completed$: Observable<void>;
}

// @public
export interface KibanaRequestRoute<Method extends RouteMethod> {
    // (undocumented)
    method: Method;
    // (undocumented)
    options: KibanaRequestRouteOptions<Method>;
    // (undocumented)
    path: string;
}

// @public
export type KibanaRequestRouteOptions<Method extends RouteMethod> = Method extends 'get' | 'options' ? Required<Omit<RouteConfigOptions<Method>, 'body'>> : Required<RouteConfigOptions<Method>>;

// @public
export type KibanaResponseFactory = typeof kibanaResponseFactory;

// @public
export const kibanaResponseFactory: {
    custom: <T extends string | Record<string, any> | Error | Buffer | Stream | {
        message: string | Error;
        attributes?: ResponseErrorAttributes | undefined;
    } | undefined>(options: CustomHttpResponseOptions<T>) => KibanaResponse<T>;
    badRequest: (options?: ErrorHttpResponseOptions) => KibanaResponse<string | Error | {
        message: string | Error;
        attributes?: ResponseErrorAttributes | undefined;
    }>;
    unauthorized: (options?: ErrorHttpResponseOptions) => KibanaResponse<string | Error | {
        message: string | Error;
        attributes?: ResponseErrorAttributes | undefined;
    }>;
    forbidden: (options?: ErrorHttpResponseOptions) => KibanaResponse<string | Error | {
        message: string | Error;
        attributes?: ResponseErrorAttributes | undefined;
    }>;
    notFound: (options?: ErrorHttpResponseOptions) => KibanaResponse<string | Error | {
        message: string | Error;
        attributes?: ResponseErrorAttributes | undefined;
    }>;
    conflict: (options?: ErrorHttpResponseOptions) => KibanaResponse<string | Error | {
        message: string | Error;
        attributes?: ResponseErrorAttributes | undefined;
    }>;
    customError: (options: CustomHttpResponseOptions<ResponseError>) => KibanaResponse<string | Error | {
        message: string | Error;
        attributes?: ResponseErrorAttributes | undefined;
    }>;
    redirected: (options: RedirectResponseOptions) => KibanaResponse<string | Record<string, any> | Buffer | Stream>;
    ok: (options?: HttpResponseOptions) => KibanaResponse<string | Record<string, any> | Buffer | Stream>;
    accepted: (options?: HttpResponseOptions) => KibanaResponse<string | Record<string, any> | Buffer | Stream>;
    noContent: (options?: HttpResponseOptions) => KibanaResponse<undefined>;
};

// Warning: (ae-forgotten-export) The symbol "KnownKeys" needs to be exported by the entry point index.d.ts
//
// @public
export type KnownHeaders = KnownKeys<IncomingHttpHeaders>;

// Warning: (ae-forgotten-export) The symbol "lifecycleResponseFactory" needs to be exported by the entry point index.d.ts
//
// @public
export type LifecycleResponseFactory = typeof lifecycleResponseFactory;

export { Logger_2 as Logger }

// Warning: (ae-forgotten-export) The symbol "loggerSchema" needs to be exported by the entry point index.d.ts
//
// @public (undocumented)
export type LoggerConfigType = TypeOf<typeof loggerSchema>;

// @public (undocumented)
export interface LoggerContextConfigInput {
    // (undocumented)
    appenders?: Record<string, AppenderConfigType> | Map<string, AppenderConfigType>;
    // (undocumented)
    loggers?: LoggerConfigType[];
}

export { LoggerFactory }

// @public
export interface LoggingServiceSetup {
    configure(config$: Observable<LoggerContextConfigInput>): void;
}

export { LogLevel_2 as LogLevel }

export { LogMeta }

export { LogRecord }

// @public
export type MakeUsageFromSchema<T> = {
    [Key in keyof T]?: T[Key] extends Maybe<object[]> ? false : T[Key] extends Maybe<any[]> ? boolean : T[Key] extends Maybe<object> ? MakeUsageFromSchema<T[Key]> | boolean : boolean;
};

// @public
export interface MetricsServiceSetup {
    readonly collectionInterval: number;
    getOpsMetrics$: () => Observable<OpsMetrics>;
}

// @public
export type MetricsServiceStart = MetricsServiceSetup;

// @public
export type MutatingOperationRefreshSetting = boolean | 'wait_for';

// Warning: (ae-missing-release-tag) "NodesVersionCompatibility" is part of the package's API, but it is missing a release tag (@alpha, @beta, @public, or @internal)
//
// @public (undocumented)
export interface NodesVersionCompatibility {
    // Warning: (ae-forgotten-export) The symbol "NodeInfo" needs to be exported by the entry point index.d.ts
    //
    // (undocumented)
    incompatibleNodes: NodeInfo[];
    // (undocumented)
    isCompatible: boolean;
    // (undocumented)
    kibanaVersion: string;
    // (undocumented)
    message?: string;
    // (undocumented)
    nodesInfoRequestError?: Error;
    // (undocumented)
    warningNodes: NodeInfo[];
}

// Warning: (ae-forgotten-export) The symbol "OnPostAuthResult" needs to be exported by the entry point index.d.ts
//
// @public
export type OnPostAuthHandler = (request: KibanaRequest, response: LifecycleResponseFactory, toolkit: OnPostAuthToolkit) => OnPostAuthResult | KibanaResponse | Promise<OnPostAuthResult | KibanaResponse>;

// @public
export interface OnPostAuthToolkit {
    next: () => OnPostAuthResult;
}

// Warning: (ae-forgotten-export) The symbol "OnPreAuthResult" needs to be exported by the entry point index.d.ts
//
// @public
export type OnPreAuthHandler = (request: KibanaRequest, response: LifecycleResponseFactory, toolkit: OnPreAuthToolkit) => OnPreAuthResult | KibanaResponse | Promise<OnPreAuthResult | KibanaResponse>;

// @public
export interface OnPreAuthToolkit {
    next: () => OnPreAuthResult;
}

// @public
export interface OnPreResponseExtensions {
    headers?: ResponseHeaders;
}

// Warning: (ae-forgotten-export) The symbol "OnPreResponseResult" needs to be exported by the entry point index.d.ts
//
// @public
export type OnPreResponseHandler = (request: KibanaRequest, preResponse: OnPreResponseInfo, toolkit: OnPreResponseToolkit) => OnPreResponseResult | Promise<OnPreResponseResult>;

// @public
export interface OnPreResponseInfo {
    // (undocumented)
    statusCode: number;
}

// @public
export interface OnPreResponseRender {
    body: string;
    headers?: ResponseHeaders;
}

// @public
export interface OnPreResponseToolkit {
    next: (responseExtensions?: OnPreResponseExtensions) => OnPreResponseResult;
    render: (responseRender: OnPreResponseRender) => OnPreResponseResult;
}

// Warning: (ae-forgotten-export) The symbol "OnPreRoutingResult" needs to be exported by the entry point index.d.ts
//
// @public
export type OnPreRoutingHandler = (request: KibanaRequest, response: LifecycleResponseFactory, toolkit: OnPreRoutingToolkit) => OnPreRoutingResult | KibanaResponse | Promise<OnPreRoutingResult | KibanaResponse>;

// @public
export interface OnPreRoutingToolkit {
    next: () => OnPreRoutingResult;
    rewriteUrl: (url: string) => OnPreRoutingResult;
}

// @public
export interface OpsMetrics {
    collected_at: Date;
    concurrent_connections: OpsServerMetrics['concurrent_connections'];
    os: OpsOsMetrics;
    // @deprecated
    process: OpsProcessMetrics;
    processes: OpsProcessMetrics[];
    requests: OpsServerMetrics['requests'];
    response_times: OpsServerMetrics['response_times'];
}

// @public
export interface OpsOsMetrics {
    cpu?: {
        control_group: string;
        cfs_period_micros: number;
        cfs_quota_micros: number;
        stat: {
            number_of_elapsed_periods: number;
            number_of_times_throttled: number;
            time_throttled_nanos: number;
        };
    };
    cpuacct?: {
        control_group: string;
        usage_nanos: number;
    };
    distro?: string;
    distroRelease?: string;
    load: {
        '1m': number;
        '5m': number;
        '15m': number;
    };
    memory: {
        total_in_bytes: number;
        free_in_bytes: number;
        used_in_bytes: number;
    };
    platform: NodeJS.Platform;
    platformRelease: string;
    uptime_in_millis: number;
}

// @public
export interface OpsProcessMetrics {
    event_loop_delay: number;
    event_loop_delay_histogram: IntervalHistogram;
    memory: {
        heap: {
            total_in_bytes: number;
            used_in_bytes: number;
            size_limit: number;
        };
        resident_set_size_in_bytes: number;
    };
    pid: number;
    uptime_in_millis: number;
}

// @public
export interface OpsServerMetrics {
    concurrent_connections: number;
    requests: {
        disconnects: number;
        total: number;
        statusCodes: Record<number, number>;
    };
    response_times: {
        avg_in_millis: number;
        max_in_millis: number;
    };
}

export { PackageInfo }

// @public
interface Plugin_2<TSetup = void, TStart = void, TPluginsSetup extends object = object, TPluginsStart extends object = object> {
    // (undocumented)
    setup(core: CoreSetup, plugins: TPluginsSetup): TSetup;
    // (undocumented)
    start(core: CoreStart, plugins: TPluginsStart): TStart;
    // (undocumented)
    stop?(): void;
}
export { Plugin_2 as Plugin }

// @public
export interface PluginConfigDescriptor<T = any> {
    // Warning: (ae-unresolved-link) The @link reference could not be resolved: This type of declaration is not supported yet by the resolver
    deprecations?: ConfigDeprecationProvider;
    exposeToBrowser?: ExposedToBrowserDescriptor<T>;
    exposeToUsage?: MakeUsageFromSchema<T>;
    schema: PluginConfigSchema<T>;
}

// @public
export type PluginConfigSchema<T> = Type<T>;

// @public
export type PluginInitializer<TSetup, TStart, TPluginsSetup extends object = object, TPluginsStart extends object = object> = (core: PluginInitializerContext) => Plugin_2<TSetup, TStart, TPluginsSetup, TPluginsStart> | PrebootPlugin<TSetup, TPluginsSetup> | AsyncPlugin<TSetup, TStart, TPluginsSetup, TPluginsStart>;

// @public
export interface PluginInitializerContext<ConfigSchema = unknown> {
    config: {
        legacy: {
            globalConfig$: Observable<SharedGlobalConfig>;
            get: () => SharedGlobalConfig;
        };
        create: <T = ConfigSchema>() => Observable<T>;
        get: <T = ConfigSchema>() => T;
    };
    // (undocumented)
    env: {
        mode: EnvironmentMode;
        packageInfo: Readonly<PackageInfo>;
        instanceUuid: string;
        configs: readonly string[];
    };
    // Warning: (ae-unresolved-link) The @link reference could not be resolved: This type of declaration is not supported yet by the resolver
    logger: LoggerFactory;
    // (undocumented)
    opaqueId: PluginOpaqueId;
}

// @public
export interface PluginManifest {
    // Warning: (ae-unresolved-link) The @link reference could not be resolved: This type of declaration is not supported yet by the resolver
    readonly configPath: ConfigPath;
    readonly description?: string;
    readonly enabledOnAnonymousPages?: boolean;
    // @deprecated
    readonly extraPublicDirs?: string[];
    readonly id: PluginName;
    readonly kibanaVersion: string;
    readonly optionalPlugins: readonly PluginName[];
    // (undocumented)
    readonly owner: {
        readonly name: string;
        readonly githubTeam?: string;
    };
    readonly requiredBundles: readonly string[];
    readonly requiredPlugins: readonly PluginName[];
    readonly server: boolean;
    readonly serviceFolders?: readonly string[];
    readonly type: PluginType;
    readonly ui: boolean;
    readonly version: string;
}

// @public
export type PluginName = string;

// @public (undocumented)
export type PluginOpaqueId = symbol;

// @internal (undocumented)
export interface PluginsServiceSetup {
    contracts: Map<PluginName, unknown>;
    initialized: boolean;
}

// @internal (undocumented)
export interface PluginsServiceStart {
    contracts: Map<PluginName, unknown>;
}

// @public (undocumented)
export enum PluginType {
    preboot = "preboot",
    standard = "standard"
}

// @public
export interface PrebootPlugin<TSetup = void, TPluginsSetup extends object = object> {
    // (undocumented)
    setup(core: CorePreboot, plugins: TPluginsSetup): TSetup;
    // (undocumented)
    stop?(): void;
}

// @public
export interface PrebootServicePreboot {
    readonly holdSetupUntilResolved: (reason: string, promise: Promise<{
        shouldReloadConfig: boolean;
    } | undefined>) => void;
    readonly isSetupOnHold: () => boolean;
}

// @public
export type PublicUiSettingsParams = Omit<UiSettingsParams, 'schema'>;

// @public
export type RedirectResponseOptions = HttpResponseOptions & {
    headers: {
        location: string;
    };
};

// @public (undocumented)
export interface RegisterDeprecationsConfig {
    // (undocumented)
    getDeprecations: (context: GetDeprecationsContext) => MaybePromise<DeprecationsDetails[]>;
}

// @public
export type RequestHandler<P = unknown, Q = unknown, B = unknown, Context extends RequestHandlerContext = RequestHandlerContext, Method extends RouteMethod = any, ResponseFactory extends KibanaResponseFactory = KibanaResponseFactory> = (context: Context, request: KibanaRequest<P, Q, B, Method>, response: ResponseFactory) => IKibanaResponse<any> | Promise<IKibanaResponse<any>>;

// @public
export interface RequestHandlerContext {
    // (undocumented)
    core: {
        savedObjects: {
            client: SavedObjectsClientContract;
            typeRegistry: ISavedObjectTypeRegistry;
            getClient: (options?: SavedObjectsClientProviderOptions) => SavedObjectsClientContract;
            getExporter: (client: SavedObjectsClientContract) => ISavedObjectsExporter;
            getImporter: (client: SavedObjectsClientContract) => ISavedObjectsImporter;
        };
        elasticsearch: {
            client: IScopedClusterClient;
        };
        uiSettings: {
            client: IUiSettingsClient;
        };
        deprecations: {
            client: DeprecationsClient;
        };
    };
}

// @public
export type RequestHandlerContextContainer = IContextContainer;

// @public
export type RequestHandlerContextProvider<Context extends RequestHandlerContext, ContextName extends keyof Context> = IContextProvider<Context, ContextName>;

// @public
export type RequestHandlerWrapper = <P, Q, B, Context extends RequestHandlerContext = RequestHandlerContext, Method extends RouteMethod = any, ResponseFactory extends KibanaResponseFactory = KibanaResponseFactory>(handler: RequestHandler<P, Q, B, Context, Method, ResponseFactory>) => RequestHandler<P, Q, B, Context, Method, ResponseFactory>;

// @public
export interface ResolveCapabilitiesOptions {
    useDefaultCapabilities: boolean;
}

// @public
export type ResponseError = string | Error | {
    message: string | Error;
    attributes?: ResponseErrorAttributes;
};

// @public
export type ResponseErrorAttributes = Record<string, any>;

// @public
export type ResponseHeaders = Record<KnownHeaders, string | string[]> | Record<string, string | string[]>;

// @public
export interface RouteConfig<P, Q, B, Method extends RouteMethod> {
    options?: RouteConfigOptions<Method>;
    path: string;
    validate: RouteValidatorFullConfig<P, Q, B> | false;
}

// @public
export interface RouteConfigOptions<Method extends RouteMethod> {
    authRequired?: boolean | 'optional';
    body?: Method extends 'get' | 'options' ? undefined : RouteConfigOptionsBody;
    tags?: readonly string[];
    timeout?: {
        payload?: Method extends 'get' | 'options' ? undefined : number;
        idleSocket?: number;
    };
    xsrfRequired?: Method extends 'get' ? never : boolean;
}

// @public
export interface RouteConfigOptionsBody {
    accepts?: RouteContentType | RouteContentType[] | string | string[];
    maxBytes?: number;
    output?: typeof validBodyOutput[number];
    parse?: boolean | 'gunzip';
}

// @public
export type RouteContentType = 'application/json' | 'application/*+json' | 'application/octet-stream' | 'application/x-www-form-urlencoded' | 'multipart/form-data' | 'text/*';

// @public
export type RouteMethod = SafeRouteMethod | DestructiveRouteMethod;

// @public
export type RouteRegistrar<Method extends RouteMethod, Context extends RequestHandlerContext = RequestHandlerContext> = <P, Q, B>(route: RouteConfig<P, Q, B, Method>, handler: RequestHandler<P, Q, B, Context, Method>) => void;

// @public
export class RouteValidationError extends SchemaTypeError {
    constructor(error: Error | string, path?: string[]);
}

// @public
export type RouteValidationFunction<T> = (data: any, validationResult: RouteValidationResultFactory) => {
    value: T;
    error?: never;
} | {
    value?: never;
    error: RouteValidationError;
};

// @public
export interface RouteValidationResultFactory {
    // (undocumented)
    badRequest: (error: Error | string, path?: string[]) => {
        error: RouteValidationError;
    };
    // (undocumented)
    ok: <T>(value: T) => {
        value: T;
    };
}

// @public
export type RouteValidationSpec<T> = ObjectType | Type<T> | RouteValidationFunction<T>;

// @public
export interface RouteValidatorConfig<P, Q, B> {
    body?: RouteValidationSpec<B>;
    params?: RouteValidationSpec<P>;
    query?: RouteValidationSpec<Q>;
}

// @public
export type RouteValidatorFullConfig<P, Q, B> = RouteValidatorConfig<P, Q, B> & RouteValidatorOptions;

// @public
export interface RouteValidatorOptions {
    unsafe?: {
        params?: boolean;
        query?: boolean;
        body?: boolean;
    };
}

// @public
export type SafeRouteMethod = 'get' | 'options';

// Warning: (ae-missing-release-tag) "SavedObject" is part of the package's API, but it is missing a release tag (@alpha, @beta, @public, or @internal)
//
// @public (undocumented)
export interface SavedObject<T = unknown> {
    attributes: T;
    coreMigrationVersion?: string;
    // Warning: (ae-forgotten-export) The symbol "SavedObjectError" needs to be exported by the entry point index.d.ts
    //
    // (undocumented)
    error?: SavedObjectError;
    id: string;
    migrationVersion?: SavedObjectsMigrationVersion;
    namespaces?: string[];
    originId?: string;
    references: SavedObjectReference[];
    type: string;
    updated_at?: string;
    version?: string;
}

// @public
export type SavedObjectAttribute = SavedObjectAttributeSingle | SavedObjectAttributeSingle[];

// @public
export interface SavedObjectAttributes {
    // (undocumented)
    [key: string]: SavedObjectAttribute;
}

// @public
export type SavedObjectAttributeSingle = string | number | boolean | null | undefined | SavedObjectAttributes;

// @public (undocumented)
export interface SavedObjectExportBaseOptions {
    excludeExportDetails?: boolean;
    includeNamespaces?: boolean;
    includeReferencesDeep?: boolean;
    namespace?: string;
    request: KibanaRequest;
}

// @public
export interface SavedObjectMigrationContext {
    readonly convertToMultiNamespaceTypeVersion?: string;
    readonly isSingleNamespaceType: boolean;
    readonly log: SavedObjectsMigrationLogger;
    readonly migrationVersion: string;
}

// @public
export type SavedObjectMigrationFn<InputAttributes = unknown, MigratedAttributes = unknown> = (doc: SavedObjectUnsanitizedDoc<InputAttributes>, context: SavedObjectMigrationContext) => SavedObjectUnsanitizedDoc<MigratedAttributes>;

// @public
export interface SavedObjectMigrationMap {
    // (undocumented)
    [version: string]: SavedObjectMigrationFn<any, any>;
}

// @public
export interface SavedObjectReference {
    // (undocumented)
    id: string;
    // (undocumented)
    name: string;
    // (undocumented)
    type: string;
}

// @public
export interface SavedObjectReferenceWithContext {
    id: string;
    inboundReferences: Array<{
        type: string;
        id: string;
        name: string;
    }>;
    isMissing?: boolean;
    spaces: string[];
    spacesWithMatchingAliases?: string[];
    type: string;
}

// Warning: (ae-forgotten-export) The symbol "SavedObjectDoc" needs to be exported by the entry point index.d.ts
// Warning: (ae-forgotten-export) The symbol "Referencable" needs to be exported by the entry point index.d.ts
//
// @public
export type SavedObjectSanitizedDoc<T = unknown> = SavedObjectDoc<T> & Referencable;

// @public (undocumented)
export interface SavedObjectsBaseOptions {
    namespace?: string;
}

// @public (undocumented)
export interface SavedObjectsBulkCreateObject<T = unknown> {
    // (undocumented)
    attributes: T;
    coreMigrationVersion?: string;
    // (undocumented)
    id?: string;
    initialNamespaces?: string[];
    migrationVersion?: SavedObjectsMigrationVersion;
    originId?: string;
    // (undocumented)
    references?: SavedObjectReference[];
    // (undocumented)
    type: string;
    // (undocumented)
    version?: string;
}

// @public (undocumented)
export interface SavedObjectsBulkGetObject {
    fields?: string[];
    // (undocumented)
    id: string;
    namespaces?: string[];
    // (undocumented)
    type: string;
}

// @public (undocumented)
export interface SavedObjectsBulkResolveObject {
    // (undocumented)
    id: string;
    // (undocumented)
    type: string;
}

// @public (undocumented)
export interface SavedObjectsBulkResolveResponse<T = unknown> {
    // (undocumented)
    resolved_objects: Array<SavedObjectsResolveResponse<T>>;
}

// @public (undocumented)
export interface SavedObjectsBulkResponse<T = unknown> {
    // (undocumented)
    saved_objects: Array<SavedObject<T>>;
}

// @public (undocumented)
export interface SavedObjectsBulkResponse<T = unknown> {
    // (undocumented)
    saved_objects: Array<SavedObject<T>>;
}

// @public (undocumented)
export interface SavedObjectsBulkUpdateObject<T = unknown> extends Pick<SavedObjectsUpdateOptions<T>, 'version' | 'references'> {
    attributes: Partial<T>;
    id: string;
    namespace?: string;
    type: string;
}

// @public (undocumented)
export interface SavedObjectsBulkUpdateOptions extends SavedObjectsBaseOptions {
    refresh?: MutatingOperationRefreshSetting;
}

// @public (undocumented)
export interface SavedObjectsBulkUpdateResponse<T = unknown> {
    // (undocumented)
    saved_objects: Array<SavedObjectsUpdateResponse<T>>;
}

// @public (undocumented)
export interface SavedObjectsCheckConflictsObject {
    // (undocumented)
    id: string;
    // (undocumented)
    type: string;
}

// @public (undocumented)
export interface SavedObjectsCheckConflictsResponse {
    // (undocumented)
    errors: Array<{
        id: string;
        type: string;
        error: SavedObjectError;
    }>;
}

// @public (undocumented)
export class SavedObjectsClient {
    // @internal
    constructor(repository: ISavedObjectsRepository);
    bulkCreate<T = unknown>(objects: Array<SavedObjectsBulkCreateObject<T>>, options?: SavedObjectsCreateOptions): Promise<SavedObjectsBulkResponse<T>>;
    bulkGet<T = unknown>(objects?: SavedObjectsBulkGetObject[], options?: SavedObjectsBaseOptions): Promise<SavedObjectsBulkResponse<T>>;
    bulkResolve<T = unknown>(objects: SavedObjectsBulkResolveObject[], options?: SavedObjectsBaseOptions): Promise<SavedObjectsBulkResolveResponse<T>>;
    bulkUpdate<T = unknown>(objects: Array<SavedObjectsBulkUpdateObject<T>>, options?: SavedObjectsBulkUpdateOptions): Promise<SavedObjectsBulkUpdateResponse<T>>;
    checkConflicts(objects?: SavedObjectsCheckConflictsObject[], options?: SavedObjectsBaseOptions): Promise<SavedObjectsCheckConflictsResponse>;
    closePointInTime(id: string, options?: SavedObjectsClosePointInTimeOptions): Promise<SavedObjectsClosePointInTimeResponse>;
    collectMultiNamespaceReferences(objects: SavedObjectsCollectMultiNamespaceReferencesObject[], options?: SavedObjectsCollectMultiNamespaceReferencesOptions): Promise<SavedObjectsCollectMultiNamespaceReferencesResponse>;
    create<T = unknown>(type: string, attributes: T, options?: SavedObjectsCreateOptions): Promise<SavedObject<T>>;
    createPointInTimeFinder<T = unknown, A = unknown>(findOptions: SavedObjectsCreatePointInTimeFinderOptions, dependencies?: SavedObjectsCreatePointInTimeFinderDependencies): ISavedObjectsPointInTimeFinder<T, A>;
    delete(type: string, id: string, options?: SavedObjectsDeleteOptions): Promise<{}>;
    // (undocumented)
    static errors: typeof SavedObjectsErrorHelpers;
    // (undocumented)
    errors: typeof SavedObjectsErrorHelpers;
    find<T = unknown, A = unknown>(options: SavedObjectsFindOptions): Promise<SavedObjectsFindResponse<T, A>>;
    get<T = unknown>(type: string, id: string, options?: SavedObjectsBaseOptions): Promise<SavedObject<T>>;
    openPointInTimeForType(type: string | string[], options?: SavedObjectsOpenPointInTimeOptions): Promise<SavedObjectsOpenPointInTimeResponse>;
    removeReferencesTo(type: string, id: string, options?: SavedObjectsRemoveReferencesToOptions): Promise<SavedObjectsRemoveReferencesToResponse>;
    resolve<T = unknown>(type: string, id: string, options?: SavedObjectsBaseOptions): Promise<SavedObjectsResolveResponse<T>>;
    update<T = unknown>(type: string, id: string, attributes: Partial<T>, options?: SavedObjectsUpdateOptions<T>): Promise<SavedObjectsUpdateResponse<T>>;
    updateObjectsSpaces(objects: SavedObjectsUpdateObjectsSpacesObject[], spacesToAdd: string[], spacesToRemove: string[], options?: SavedObjectsUpdateObjectsSpacesOptions): Promise<SavedObjectsUpdateObjectsSpacesResponse>;
}

// @public
export type SavedObjectsClientContract = Pick<SavedObjectsClient, keyof SavedObjectsClient>;

// @public
export type SavedObjectsClientFactory = ({ request, includedHiddenTypes, }: {
    request: KibanaRequest;
    includedHiddenTypes?: string[];
}) => SavedObjectsClientContract;

// @public
export type SavedObjectsClientFactoryProvider = (repositoryFactory: SavedObjectsRepositoryFactory) => SavedObjectsClientFactory;

// @public
export interface SavedObjectsClientProviderOptions {
    // (undocumented)
    excludedWrappers?: string[];
    // (undocumented)
    includedHiddenTypes?: string[];
}

// @public
export type SavedObjectsClientWrapperFactory = (options: SavedObjectsClientWrapperOptions) => SavedObjectsClientContract;

// @public
export interface SavedObjectsClientWrapperOptions {
    // (undocumented)
    client: SavedObjectsClientContract;
    // (undocumented)
    request: KibanaRequest;
    // (undocumented)
    typeRegistry: ISavedObjectTypeRegistry;
}

// @public (undocumented)
export type SavedObjectsClosePointInTimeOptions = SavedObjectsBaseOptions;

// @public (undocumented)
export interface SavedObjectsClosePointInTimeResponse {
    num_freed: number;
    succeeded: boolean;
}

// @public
export interface SavedObjectsCollectMultiNamespaceReferencesObject {
    // (undocumented)
    id: string;
    // (undocumented)
    type: string;
}

// @public
export interface SavedObjectsCollectMultiNamespaceReferencesOptions extends SavedObjectsBaseOptions {
    purpose?: 'collectMultiNamespaceReferences' | 'updateObjectsSpaces';
}

// @public
export interface SavedObjectsCollectMultiNamespaceReferencesResponse {
    // (undocumented)
    objects: SavedObjectReferenceWithContext[];
}

// @public (undocumented)
export interface SavedObjectsCreateOptions extends SavedObjectsBaseOptions {
    coreMigrationVersion?: string;
    id?: string;
    initialNamespaces?: string[];
    migrationVersion?: SavedObjectsMigrationVersion;
    originId?: string;
    overwrite?: boolean;
    // (undocumented)
    references?: SavedObjectReference[];
    refresh?: MutatingOperationRefreshSetting;
    version?: string;
}

// @public (undocumented)
export interface SavedObjectsCreatePointInTimeFinderDependencies {
    // (undocumented)
    client: Pick<SavedObjectsClientContract, 'find' | 'openPointInTimeForType' | 'closePointInTime'>;
}

// @public (undocumented)
export type SavedObjectsCreatePointInTimeFinderOptions = Omit<SavedObjectsFindOptions, 'page' | 'pit' | 'searchAfter'>;

// @public (undocumented)
export interface SavedObjectsDeleteByNamespaceOptions extends SavedObjectsBaseOptions {
    refresh?: boolean;
}

// @public (undocumented)
export interface SavedObjectsDeleteOptions extends SavedObjectsBaseOptions {
    force?: boolean;
    refresh?: MutatingOperationRefreshSetting;
}

// @public (undocumented)
export class SavedObjectsErrorHelpers {
    // (undocumented)
    static createBadRequestError(reason?: string): DecoratedError;
    // (undocumented)
    static createConflictError(type: string, id: string, reason?: string): DecoratedError;
    // (undocumented)
    static createGenericNotFoundError(type?: string | null, id?: string | null): DecoratedError;
    // (undocumented)
    static createGenericNotFoundEsUnavailableError(type?: string | null, id?: string | null): DecoratedError;
    // (undocumented)
    static createIndexAliasNotFoundError(alias: string): DecoratedError;
    // (undocumented)
    static createInvalidVersionError(versionInput?: string): DecoratedError;
    // (undocumented)
    static createTooManyRequestsError(type: string, id: string): DecoratedError;
    // (undocumented)
    static createUnsupportedTypeError(type: string): DecoratedError;
    // (undocumented)
    static decorateBadRequestError(error: Error, reason?: string): DecoratedError;
    // (undocumented)
    static decorateConflictError(error: Error, reason?: string): DecoratedError;
    // (undocumented)
    static decorateEsCannotExecuteScriptError(error: Error, reason?: string): DecoratedError;
    // (undocumented)
    static decorateEsUnavailableError(error: Error, reason?: string): DecoratedError;
    // (undocumented)
    static decorateForbiddenError(error: Error, reason?: string): DecoratedError;
    // (undocumented)
    static decorateGeneralError(error: Error, reason?: string): DecoratedError;
    // (undocumented)
    static decorateIndexAliasNotFoundError(error: Error, alias: string): DecoratedError;
    // (undocumented)
    static decorateNotAuthorizedError(error: Error, reason?: string): DecoratedError;
    // (undocumented)
    static decorateRequestEntityTooLargeError(error: Error, reason?: string): DecoratedError;
    // (undocumented)
    static decorateTooManyRequestsError(error: Error, reason?: string): DecoratedError;
    // (undocumented)
    static isBadRequestError(error: Error | DecoratedError): boolean;
    // (undocumented)
    static isConflictError(error: Error | DecoratedError): boolean;
    // (undocumented)
    static isEsCannotExecuteScriptError(error: Error | DecoratedError): boolean;
    // (undocumented)
    static isEsUnavailableError(error: Error | DecoratedError): boolean;
    // (undocumented)
    static isForbiddenError(error: Error | DecoratedError): boolean;
    // (undocumented)
    static isGeneralError(error: Error | DecoratedError): boolean;
    // (undocumented)
    static isInvalidVersionError(error: Error | DecoratedError): boolean;
    // (undocumented)
    static isNotAuthorizedError(error: Error | DecoratedError): boolean;
    // (undocumented)
    static isNotFoundError(error: Error | DecoratedError): boolean;
    // (undocumented)
    static isRequestEntityTooLargeError(error: Error | DecoratedError): boolean;
    // Warning: (ae-forgotten-export) The symbol "DecoratedError" needs to be exported by the entry point index.d.ts
    //
    // (undocumented)
    static isSavedObjectsClientError(error: any): error is DecoratedError;
    // (undocumented)
    static isTooManyRequestsError(error: Error | DecoratedError): boolean;
}

// @public
export interface SavedObjectsExportByObjectOptions extends SavedObjectExportBaseOptions {
    objects: Array<{
        id: string;
        type: string;
    }>;
}

// @public
export interface SavedObjectsExportByTypeOptions extends SavedObjectExportBaseOptions {
    hasReference?: SavedObjectsFindOptionsReference[];
    search?: string;
    types: string[];
}

// @public (undocumented)
export class SavedObjectsExporter {
    constructor({ savedObjectsClient, typeRegistry, exportSizeLimit, logger, }: {
        savedObjectsClient: SavedObjectsClientContract;
        typeRegistry: ISavedObjectTypeRegistry;
        exportSizeLimit: number;
        logger: Logger_2;
    });
    exportByObjects(options: SavedObjectsExportByObjectOptions): Promise<Readable>;
    exportByTypes(options: SavedObjectsExportByTypeOptions): Promise<Readable>;
}

// @public (undocumented)
export class SavedObjectsExportError extends Error {
    constructor(type: string, message: string, attributes?: Record<string, any> | undefined);
    // (undocumented)
    readonly attributes?: Record<string, any> | undefined;
    // (undocumented)
    static exportSizeExceeded(limit: number): SavedObjectsExportError;
    static invalidTransformError(objectKeys: string[]): SavedObjectsExportError;
    // (undocumented)
    static objectFetchError(objects: SavedObject[]): SavedObjectsExportError;
    static objectTransformError(objects: SavedObject[], cause: Error): SavedObjectsExportError;
    // (undocumented)
    readonly type: string;
}

// @public (undocumented)
export interface SavedObjectsExportExcludedObject {
    id: string;
    reason?: string;
    type: string;
}

// @public
export interface SavedObjectsExportResultDetails {
    excludedObjects: SavedObjectsExportExcludedObject[];
    excludedObjectsCount: number;
    exportedCount: number;
    missingRefCount: number;
    missingReferences: Array<{
        id: string;
        type: string;
    }>;
}

// @public
export type SavedObjectsExportTransform<T = unknown> = (context: SavedObjectsExportTransformContext, objects: Array<SavedObject<T>>) => SavedObject[] | Promise<SavedObject[]>;

// @public
export interface SavedObjectsExportTransformContext {
    request: KibanaRequest;
}

// @public
export type SavedObjectsFieldMapping = estypes.MappingProperty & {
    dynamic?: false | 'strict';
};

// @public (undocumented)
export interface SavedObjectsFindOptions {
    // @alpha
    aggs?: Record<string, estypes.AggregationsAggregationContainer>;
    defaultSearchOperator?: 'AND' | 'OR';
    fields?: string[];
    // Warning: (ae-forgotten-export) The symbol "KueryNode" needs to be exported by the entry point index.d.ts
    //
    // (undocumented)
    filter?: string | KueryNode;
    hasReference?: SavedObjectsFindOptionsReference | SavedObjectsFindOptionsReference[];
    hasReferenceOperator?: 'AND' | 'OR';
    // (undocumented)
    namespaces?: string[];
    // (undocumented)
    page?: number;
    // (undocumented)
    perPage?: number;
    pit?: SavedObjectsPitParams;
    preference?: string;
    rootSearchFields?: string[];
    search?: string;
    searchAfter?: estypes.Id[];
    searchFields?: string[];
    // (undocumented)
    sortField?: string;
    // (undocumented)
    sortOrder?: estypes.SearchSortOrder;
    // (undocumented)
    type: string | string[];
    typeToNamespacesMap?: Map<string, string[] | undefined>;
}

// @public (undocumented)
export interface SavedObjectsFindOptionsReference {
    // (undocumented)
    id: string;
    // (undocumented)
    type: string;
}

// @public
export interface SavedObjectsFindResponse<T = unknown, A = unknown> {
    // (undocumented)
    aggregations?: A;
    // (undocumented)
    page: number;
    // (undocumented)
    per_page: number;
    // (undocumented)
    pit_id?: string;
    // (undocumented)
    saved_objects: Array<SavedObjectsFindResult<T>>;
    // (undocumented)
    total: number;
}

// @public (undocumented)
export interface SavedObjectsFindResult<T = unknown> extends SavedObject<T> {
    score: number;
    sort?: string[];
}

// @public
export interface SavedObjectsImportActionRequiredWarning {
    actionPath: string;
    buttonLabel?: string;
    message: string;
    // (undocumented)
    type: 'action_required';
}

// @public
export interface SavedObjectsImportAmbiguousConflictError {
    // (undocumented)
    destinations: Array<{
        id: string;
        title?: string;
        updatedAt?: string;
    }>;
    // (undocumented)
    type: 'ambiguous_conflict';
}

// @public
export interface SavedObjectsImportConflictError {
    // (undocumented)
    destinationId?: string;
    // (undocumented)
    type: 'conflict';
}

// @public (undocumented)
export class SavedObjectsImporter {
    constructor({ savedObjectsClient, typeRegistry, importSizeLimit, }: {
        savedObjectsClient: SavedObjectsClientContract;
        typeRegistry: ISavedObjectTypeRegistry;
        importSizeLimit: number;
    });
    import({ readStream, createNewCopies, namespace, overwrite, }: SavedObjectsImportOptions): Promise<SavedObjectsImportResponse>;
    resolveImportErrors({ readStream, createNewCopies, namespace, retries, }: SavedObjectsResolveImportErrorsOptions): Promise<SavedObjectsImportResponse>;
}

// @public (undocumented)
export class SavedObjectsImportError extends Error {
    // (undocumented)
    readonly attributes?: Record<string, any> | undefined;
    // (undocumented)
    static importSizeExceeded(limit: number): SavedObjectsImportError;
    // (undocumented)
    static nonUniqueImportObjects(nonUniqueEntries: string[]): SavedObjectsImportError;
    // (undocumented)
    static nonUniqueRetryDestinations(nonUniqueRetryDestinations: string[]): SavedObjectsImportError;
    // (undocumented)
    static nonUniqueRetryObjects(nonUniqueRetryObjects: string[]): SavedObjectsImportError;
    // (undocumented)
    static referencesFetchError(objects: SavedObject[]): SavedObjectsImportError;
    // (undocumented)
    readonly type: string;
}

// @public
export interface SavedObjectsImportFailure {
    // (undocumented)
    error: SavedObjectsImportConflictError | SavedObjectsImportAmbiguousConflictError | SavedObjectsImportUnsupportedTypeError | SavedObjectsImportMissingReferencesError | SavedObjectsImportUnknownError;
    // (undocumented)
    id: string;
    // (undocumented)
    meta: {
        title?: string;
        icon?: string;
    };
    overwrite?: boolean;
    // @deprecated (undocumented)
    title?: string;
    // (undocumented)
    type: string;
}

// @public
export type SavedObjectsImportHook<T = unknown> = (objects: Array<SavedObject<T>>) => SavedObjectsImportHookResult | Promise<SavedObjectsImportHookResult>;

// @public
export interface SavedObjectsImportHookResult {
    warnings?: SavedObjectsImportWarning[];
}

// @public
export interface SavedObjectsImportMissingReferencesError {
    // (undocumented)
    references: Array<{
        type: string;
        id: string;
    }>;
    // (undocumented)
    type: 'missing_references';
}

// @public
export interface SavedObjectsImportOptions {
    createNewCopies: boolean;
    namespace?: string;
    overwrite: boolean;
    readStream: Readable;
}

// @public
export interface SavedObjectsImportResponse {
    // (undocumented)
    errors?: SavedObjectsImportFailure[];
    // (undocumented)
    success: boolean;
    // (undocumented)
    successCount: number;
    // (undocumented)
    successResults?: SavedObjectsImportSuccess[];
    // (undocumented)
    warnings: SavedObjectsImportWarning[];
}

// @public
export interface SavedObjectsImportRetry {
    createNewCopy?: boolean;
    destinationId?: string;
    // (undocumented)
    id: string;
    ignoreMissingReferences?: boolean;
    // (undocumented)
    overwrite: boolean;
    // (undocumented)
    replaceReferences: Array<{
        type: string;
        from: string;
        to: string;
    }>;
    // (undocumented)
    type: string;
}

// @public
export interface SavedObjectsImportSimpleWarning {
    message: string;
    // (undocumented)
    type: 'simple';
}

// @public
export interface SavedObjectsImportSuccess {
    // @deprecated (undocumented)
    createNewCopy?: boolean;
    destinationId?: string;
    // (undocumented)
    id: string;
    // (undocumented)
    meta: {
        title?: string;
        icon?: string;
    };
    overwrite?: boolean;
    // (undocumented)
    type: string;
}

// @public
export interface SavedObjectsImportUnknownError {
    // (undocumented)
    message: string;
    // (undocumented)
    statusCode: number;
    // (undocumented)
    type: 'unknown';
}

// @public
export interface SavedObjectsImportUnsupportedTypeError {
    // (undocumented)
    type: 'unsupported_type';
}

// @public
export type SavedObjectsImportWarning = SavedObjectsImportSimpleWarning | SavedObjectsImportActionRequiredWarning;

// @public (undocumented)
export interface SavedObjectsIncrementCounterField {
    fieldName: string;
    incrementBy?: number;
}

// @public (undocumented)
export interface SavedObjectsIncrementCounterOptions<Attributes = unknown> extends SavedObjectsBaseOptions {
    initialize?: boolean;
    // (undocumented)
    migrationVersion?: SavedObjectsMigrationVersion;
    refresh?: MutatingOperationRefreshSetting;
    upsertAttributes?: Attributes;
}

// @public
export interface SavedObjectsMappingProperties {
    // (undocumented)
    [field: string]: SavedObjectsFieldMapping;
}

// @public (undocumented)
export interface SavedObjectsMigrationLogger {
    // (undocumented)
    debug: (msg: string) => void;
    // (undocumented)
    error: <Meta extends LogMeta = LogMeta>(msg: string, meta: Meta) => void;
    // (undocumented)
    info: (msg: string) => void;
    // (undocumented)
    warn: (msg: string) => void;
    // @deprecated (undocumented)
    warning: (msg: string) => void;
}

// @public
export interface SavedObjectsMigrationVersion {
    // (undocumented)
    [pluginName: string]: string;
}

// @public
export type SavedObjectsNamespaceType = 'single' | 'multiple' | 'multiple-isolated' | 'agnostic';

// @public (undocumented)
export interface SavedObjectsOpenPointInTimeOptions {
    keepAlive?: string;
    namespaces?: string[];
    preference?: string;
}

// @public (undocumented)
export interface SavedObjectsOpenPointInTimeResponse {
    id: string;
}

// @public (undocumented)
export interface SavedObjectsPitParams {
    // (undocumented)
    id: string;
    // (undocumented)
    keepAlive?: string;
}

// @public
export interface SavedObjectsRawDoc {
    // (undocumented)
    _id: string;
    // (undocumented)
    _primary_term?: number;
    // (undocumented)
    _seq_no?: number;
    // Warning: (ae-forgotten-export) The symbol "SavedObjectsRawDocSource" needs to be exported by the entry point index.d.ts
    //
    // (undocumented)
    _source: SavedObjectsRawDocSource;
}

// @public
export interface SavedObjectsRawDocParseOptions {
    namespaceTreatment?: 'strict' | 'lax';
}

// @public (undocumented)
export interface SavedObjectsRemoveReferencesToOptions extends SavedObjectsBaseOptions {
    refresh?: boolean;
}

// @public (undocumented)
export interface SavedObjectsRemoveReferencesToResponse extends SavedObjectsBaseOptions {
    updated: number;
}

// @public (undocumented)
export class SavedObjectsRepository {
    bulkCreate<T = unknown>(objects: Array<SavedObjectsBulkCreateObject<T>>, options?: SavedObjectsCreateOptions): Promise<SavedObjectsBulkResponse<T>>;
    bulkGet<T = unknown>(objects?: SavedObjectsBulkGetObject[], options?: SavedObjectsBaseOptions): Promise<SavedObjectsBulkResponse<T>>;
    bulkResolve<T = unknown>(objects: SavedObjectsBulkResolveObject[], options?: SavedObjectsBaseOptions): Promise<SavedObjectsBulkResolveResponse<T>>;
    bulkUpdate<T = unknown>(objects: Array<SavedObjectsBulkUpdateObject<T>>, options?: SavedObjectsBulkUpdateOptions): Promise<SavedObjectsBulkUpdateResponse<T>>;
    checkConflicts(objects?: SavedObjectsCheckConflictsObject[], options?: SavedObjectsBaseOptions): Promise<SavedObjectsCheckConflictsResponse>;
    closePointInTime(id: string, options?: SavedObjectsClosePointInTimeOptions): Promise<SavedObjectsClosePointInTimeResponse>;
    collectMultiNamespaceReferences(objects: SavedObjectsCollectMultiNamespaceReferencesObject[], options?: SavedObjectsCollectMultiNamespaceReferencesOptions): Promise<SavedObjectsCollectMultiNamespaceReferencesResponse>;
    create<T = unknown>(type: string, attributes: T, options?: SavedObjectsCreateOptions): Promise<SavedObject<T>>;
    createPointInTimeFinder<T = unknown, A = unknown>(findOptions: SavedObjectsCreatePointInTimeFinderOptions, dependencies?: SavedObjectsCreatePointInTimeFinderDependencies): ISavedObjectsPointInTimeFinder<T, A>;
    // Warning: (ae-forgotten-export) The symbol "IKibanaMigrator" needs to be exported by the entry point index.d.ts
    //
    // @internal
    static createRepository(migrator: IKibanaMigrator, typeRegistry: ISavedObjectTypeRegistry, indexName: string, client: ElasticsearchClient, logger: Logger_2, includedHiddenTypes?: string[], injectedConstructor?: any): ISavedObjectsRepository;
    delete(type: string, id: string, options?: SavedObjectsDeleteOptions): Promise<{}>;
    deleteByNamespace(namespace: string, options?: SavedObjectsDeleteByNamespaceOptions): Promise<any>;
    // (undocumented)
    find<T = unknown, A = unknown>(options: SavedObjectsFindOptions): Promise<SavedObjectsFindResponse<T, A>>;
    get<T = unknown>(type: string, id: string, options?: SavedObjectsBaseOptions): Promise<SavedObject<T>>;
    incrementCounter<T = unknown>(type: string, id: string, counterFields: Array<string | SavedObjectsIncrementCounterField>, options?: SavedObjectsIncrementCounterOptions<T>): Promise<SavedObject<T>>;
    openPointInTimeForType(type: string | string[], { keepAlive, preference }?: SavedObjectsOpenPointInTimeOptions): Promise<SavedObjectsOpenPointInTimeResponse>;
    removeReferencesTo(type: string, id: string, options?: SavedObjectsRemoveReferencesToOptions): Promise<SavedObjectsRemoveReferencesToResponse>;
    resolve<T = unknown>(type: string, id: string, options?: SavedObjectsBaseOptions): Promise<SavedObjectsResolveResponse<T>>;
    update<T = unknown>(type: string, id: string, attributes: Partial<T>, options?: SavedObjectsUpdateOptions<T>): Promise<SavedObjectsUpdateResponse<T>>;
    updateObjectsSpaces(objects: SavedObjectsUpdateObjectsSpacesObject[], spacesToAdd: string[], spacesToRemove: string[], options?: SavedObjectsUpdateObjectsSpacesOptions): Promise<SavedObjectsUpdateObjectsSpacesResponse>;
}

// @public
export interface SavedObjectsRepositoryFactory {
    createInternalRepository: (includedHiddenTypes?: string[]) => ISavedObjectsRepository;
    createScopedRepository: (req: KibanaRequest, includedHiddenTypes?: string[]) => ISavedObjectsRepository;
}

// @public
export interface SavedObjectsResolveImportErrorsOptions {
    createNewCopies: boolean;
    namespace?: string;
    readStream: Readable;
    retries: SavedObjectsImportRetry[];
}

// @public (undocumented)
export interface SavedObjectsResolveResponse<T = unknown> {
    alias_target_id?: string;
    outcome: 'exactMatch' | 'aliasMatch' | 'conflict';
    saved_object: SavedObject<T>;
}

// @public
export class SavedObjectsSerializer {
    // @internal
    constructor(registry: ISavedObjectTypeRegistry);
    generateRawId(namespace: string | undefined, type: string, id: string): string;
    generateRawLegacyUrlAliasId(namespace: string, type: string, id: string): string;
    isRawSavedObject(doc: SavedObjectsRawDoc, options?: SavedObjectsRawDocParseOptions): boolean;
    rawToSavedObject<T = unknown>(doc: SavedObjectsRawDoc, options?: SavedObjectsRawDocParseOptions): SavedObjectSanitizedDoc<T>;
    savedObjectToRaw(savedObj: SavedObjectSanitizedDoc): SavedObjectsRawDoc;
}

// @public
export interface SavedObjectsServiceSetup {
    addClientWrapper: (priority: number, id: string, factory: SavedObjectsClientWrapperFactory) => void;
    registerType: <Attributes = any>(type: SavedObjectsType<Attributes>) => void;
    setClientFactoryProvider: (clientFactoryProvider: SavedObjectsClientFactoryProvider) => void;
}

// @public
export interface SavedObjectsServiceStart {
    createExporter: (client: SavedObjectsClientContract) => ISavedObjectsExporter;
    createImporter: (client: SavedObjectsClientContract) => ISavedObjectsImporter;
    createInternalRepository: (includedHiddenTypes?: string[]) => ISavedObjectsRepository;
    createScopedRepository: (req: KibanaRequest, includedHiddenTypes?: string[]) => ISavedObjectsRepository;
    createSerializer: () => SavedObjectsSerializer;
    getScopedClient: (req: KibanaRequest, options?: SavedObjectsClientProviderOptions) => SavedObjectsClientContract;
    getTypeRegistry: () => ISavedObjectTypeRegistry;
}

// @public
export interface SavedObjectStatusMeta {
    // (undocumented)
    migratedIndices: {
        [status: string]: number;
        skipped: number;
        migrated: number;
    };
}

// @public (undocumented)
export interface SavedObjectsType<Attributes = any> {
    convertToAliasScript?: string;
    convertToMultiNamespaceTypeVersion?: string;
    excludeOnUpgrade?: SavedObjectTypeExcludeFromUpgradeFilterHook;
    hidden: boolean;
    indexPattern?: string;
    management?: SavedObjectsTypeManagementDefinition<Attributes>;
    mappings: SavedObjectsTypeMappingDefinition;
    migrations?: SavedObjectMigrationMap | (() => SavedObjectMigrationMap);
    name: string;
    namespaceType: SavedObjectsNamespaceType;
}

// @public
export interface SavedObjectsTypeManagementDefinition<Attributes = any> {
    defaultSearchField?: string;
    displayName?: string;
    getEditUrl?: (savedObject: SavedObject<Attributes>) => string;
    getInAppUrl?: (savedObject: SavedObject<Attributes>) => {
        path: string;
        uiCapabilitiesPath: string;
    };
    getTitle?: (savedObject: SavedObject<Attributes>) => string;
    icon?: string;
    importableAndExportable?: boolean;
    // Warning: (ae-forgotten-export) The symbol "SavedObjectsExportablePredicate" needs to be exported by the entry point index.d.ts
    isExportable?: SavedObjectsExportablePredicate<Attributes>;
    onExport?: SavedObjectsExportTransform<Attributes>;
    onImport?: SavedObjectsImportHook<Attributes>;
    visibleInManagement?: boolean;
}

// @public
export interface SavedObjectsTypeMappingDefinition {
    dynamic?: false | 'strict';
    properties: SavedObjectsMappingProperties;
}

// @public
export interface SavedObjectsUpdateObjectsSpacesObject {
    id: string;
    // @internal
    spaces?: string[];
    type: string;
    // @internal
    version?: string;
}

// @public
export interface SavedObjectsUpdateObjectsSpacesOptions extends SavedObjectsBaseOptions {
    refresh?: MutatingOperationRefreshSetting;
}

// @public
export interface SavedObjectsUpdateObjectsSpacesResponse {
    // (undocumented)
    objects: SavedObjectsUpdateObjectsSpacesResponseObject[];
}

// @public
export interface SavedObjectsUpdateObjectsSpacesResponseObject {
    error?: SavedObjectError;
    id: string;
    spaces: string[];
    type: string;
}

// @public (undocumented)
export interface SavedObjectsUpdateOptions<Attributes = unknown> extends SavedObjectsBaseOptions {
    references?: SavedObjectReference[];
    refresh?: MutatingOperationRefreshSetting;
    upsert?: Attributes;
    version?: string;
}

// @public (undocumented)
export interface SavedObjectsUpdateResponse<T = unknown> extends Omit<SavedObject<T>, 'attributes' | 'references'> {
    // (undocumented)
    attributes: Partial<T>;
    // (undocumented)
    references: SavedObjectReference[] | undefined;
}

// @public (undocumented)
export class SavedObjectsUtils {
    static createEmptyFindResponse: <T, A>({ page, perPage, }: SavedObjectsFindOptions) => SavedObjectsFindResponse<T, A>;
    static generateId(): string;
    static getConvertedObjectId(namespace: string | undefined, type: string, id: string): string;
    static isRandomId(id: string | undefined): boolean;
    static namespaceIdToString: (namespace?: string) => string;
    static namespaceStringToId: (namespace: string) => string | undefined;
}

// Warning: (ae-extra-release-tag) The doc comment should not contain more than one release tag
//
// @public
export type SavedObjectTypeExcludeFromUpgradeFilterHook = (toolkit: {
    readonlyEsClient: Pick<ElasticsearchClient, 'search'>;
}) => estypes.QueryDslQueryContainer | Promise<estypes.QueryDslQueryContainer>;

// @public
export class SavedObjectTypeRegistry {
    getAllTypes(): SavedObjectsType<any>[];
    getImportableAndExportableTypes(): SavedObjectsType<any>[];
    getIndex(type: string): string | undefined;
    getType(type: string): SavedObjectsType<any> | undefined;
    getVisibleTypes(): SavedObjectsType<any>[];
    isHidden(type: string): boolean;
    isImportableAndExportable(type: string): boolean;
    isMultiNamespace(type: string): boolean;
    isNamespaceAgnostic(type: string): boolean;
    isShareable(type: string): boolean;
    isSingleNamespace(type: string): boolean;
    registerType(type: SavedObjectsType): void;
}

// @public
export type SavedObjectUnsanitizedDoc<T = unknown> = SavedObjectDoc<T> & Partial<Referencable>;

// @public
export type ScopeableRequest = KibanaRequest | FakeRequest;

// @public (undocumented)
export interface SearchResponse<T = unknown> {
    // (undocumented)
    aggregations?: any;
    // (undocumented)
    hits: {
        total: number;
        max_score: number;
        hits: Array<{
            _index: string;
            _type: string;
            _id: string;
            _score: number;
            _source: T;
            _version?: number;
            _explanation?: Explanation;
            fields?: any;
            highlight?: any;
            inner_hits?: any;
            matched_queries?: string[];
            sort?: unknown[];
        }>;
    };
    // (undocumented)
    pit_id?: string;
    // (undocumented)
    _scroll_id?: string;
    // (undocumented)
    _shards: ShardsResponse;
    // (undocumented)
    timed_out: boolean;
    // (undocumented)
    took: number;
}

// @public
export interface ServiceStatus<Meta extends Record<string, any> | unknown = unknown> {
    detail?: string;
    documentationUrl?: string;
    level: ServiceStatusLevel;
    meta?: Meta;
    summary: string;
}

// @public
export type ServiceStatusLevel = typeof ServiceStatusLevels[keyof typeof ServiceStatusLevels];

// @public
export const ServiceStatusLevels: Readonly<{
    available: Readonly<{
        toString: () => "available";
        valueOf: () => 0;
        toJSON: () => "available";
    }>;
    degraded: Readonly<{
        toString: () => "degraded";
        valueOf: () => 1;
        toJSON: () => "degraded";
    }>;
    unavailable: Readonly<{
        toString: () => "unavailable";
        valueOf: () => 2;
        toJSON: () => "unavailable";
    }>;
    critical: Readonly<{
        toString: () => "critical";
        valueOf: () => 3;
        toJSON: () => "critical";
    }>;
}>;

// @public
export interface SessionCookieValidationResult {
    isValid: boolean;
    path?: string;
}

// @public
export interface SessionStorage<T> {
    clear(): void;
    get(): Promise<T | null>;
    set(sessionValue: T): void;
}

// @public
export interface SessionStorageCookieOptions<T> {
    encryptionKey: string;
    isSecure: boolean;
    name: string;
    sameSite?: 'Strict' | 'Lax' | 'None';
    validate: (sessionValue: T | T[]) => SessionCookieValidationResult;
}

// @public
export interface SessionStorageFactory<T> {
    // (undocumented)
    asScoped: (request: KibanaRequest) => SessionStorage<T>;
}

// @public (undocumented)
export interface ShardsInfo {
    // (undocumented)
    failed: number;
    // (undocumented)
    skipped: number;
    // (undocumented)
    successful: number;
    // (undocumented)
    total: number;
}

// @public (undocumented)
export interface ShardsResponse {
    // (undocumented)
    failed: number;
    // (undocumented)
    skipped: number;
    // (undocumented)
    successful: number;
    // (undocumented)
    total: number;
}

// @public (undocumented)
export type SharedGlobalConfig = RecursiveReadonly<{
    kibana: Pick<KibanaConfigType, typeof SharedGlobalConfigKeys.kibana[number]>;
    elasticsearch: Pick<ElasticsearchConfigType, typeof SharedGlobalConfigKeys.elasticsearch[number]>;
    path: Pick<PathConfigType, typeof SharedGlobalConfigKeys.path[number]>;
    savedObjects: Pick<SavedObjectsConfigType, typeof SharedGlobalConfigKeys.savedObjects[number]>;
}>;

// @public
export type StartServicesAccessor<TPluginsStart extends object = object, TStart = unknown> = () => Promise<[CoreStart, TPluginsStart, TStart]>;

// Warning: (ae-unresolved-link) The @link reference could not be resolved: The package "kibana" does not have an export "ServiceStatusSetup"
// Warning: (ae-unresolved-link) The @link reference could not be resolved: The package "kibana" does not have an export "ServiceStatusSetup"
//
// @public
export interface StatusServiceSetup {
    core$: Observable<CoreStatus>;
    dependencies$: Observable<Record<string, ServiceStatus>>;
    // Warning: (ae-unresolved-link) The @link reference could not be resolved: The package "kibana" does not have an export "StatusSetup"
    derivedStatus$: Observable<ServiceStatus>;
    isStatusPageAnonymous: () => boolean;
    overall$: Observable<ServiceStatus>;
    set(status$: Observable<ServiceStatus>): void;
}

// @public
export interface UiSettingsParams<T = unknown> {
    category?: string[];
    deprecation?: DeprecationSettings;
    description?: string;
    // @deprecated
    metric?: {
        type: UiCounterMetricType;
        name: string;
    };
    name?: string;
    optionLabels?: Record<string, string>;
    options?: string[];
    order?: number;
    readonly?: boolean;
    requiresPageReload?: boolean;
    // (undocumented)
    schema: Type<T>;
    sensitive?: boolean;
    type?: UiSettingsType;
    value?: T;
}

// @public (undocumented)
export interface UiSettingsServiceSetup {
    register(settings: Record<string, UiSettingsParams>): void;
}

// @public (undocumented)
export interface UiSettingsServiceStart {
    asScopedToClient(savedObjectsClient: SavedObjectsClientContract): IUiSettingsClient;
}

// @public
export type UiSettingsType = 'undefined' | 'json' | 'markdown' | 'number' | 'select' | 'boolean' | 'string' | 'array' | 'image' | 'color';

// @public
export interface UserProvidedValues<T = any> {
    // (undocumented)
    isOverridden?: boolean;
    // (undocumented)
    userValue?: T;
}

// @public
export const validBodyOutput: readonly ["data", "stream"];

// Warnings were encountered during analysis:
//
// bazel-kibana/packages/kbn-config-schema/src/byte_size_value/index.ts:1:1 - (ae-wrong-input-file-type) Incorrect file type; API Extractor expects to analyze compiler outputs with the .d.ts file extension. Troubleshooting tips: https://api-extractor.com/link/dts-error
// src/core/server/elasticsearch/client/types.ts:94:7 - (ae-forgotten-export) The symbol "Explanation" needs to be exported by the entry point index.d.ts
// src/core/server/http/router/response.ts:302:3 - (ae-forgotten-export) The symbol "KibanaResponse" needs to be exported by the entry point index.d.ts
// src/core/server/plugins/types.ts:406:3 - (ae-forgotten-export) The symbol "KibanaConfigType" needs to be exported by the entry point index.d.ts
// src/core/server/plugins/types.ts:406:3 - (ae-forgotten-export) The symbol "SharedGlobalConfigKeys" needs to be exported by the entry point index.d.ts
// src/core/server/plugins/types.ts:409:3 - (ae-forgotten-export) The symbol "SavedObjectsConfigType" needs to be exported by the entry point index.d.ts
// src/core/server/plugins/types.ts:515:5 - (ae-unresolved-link) The @link reference could not be resolved: The package "kibana" does not have an export "create"

```
