"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.waitForPickupUpdatedMappingsTask = void 0;
var TaskEither = _interopRequireWildcard(require("fp-ts/lib/TaskEither"));
var Option = _interopRequireWildcard(require("fp-ts/lib/Option"));
var _function = require("fp-ts/lib/function");
var _wait_for_task = require("./wait_for_task");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const waitForPickupUpdatedMappingsTask = exports.waitForPickupUpdatedMappingsTask = (0, _function.flow)(_wait_for_task.waitForTask, TaskEither.chain(res => {
  // We don't catch or type failures/errors because they should never
  // occur in our migration algorithm and we don't have any business logic
  // for dealing with it. If something happens we'll just crash and try
  // again.
  if (Option.isSome(res.failures)) {
    throw new Error('pickupUpdatedMappings task failed with the following failures:\n' + JSON.stringify(res.failures.value));
  } else if (Option.isSome(res.error)) {
    throw new Error('pickupUpdatedMappings task failed with the following error:\n' + JSON.stringify(res.error.value));
  } else {
    return TaskEither.right('pickup_updated_mappings_succeeded');
  }
}));