"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setWriteBlock = void 0;
var Either = _interopRequireWildcard(require("fp-ts/lib/Either"));
var _elasticsearch = require("@elastic/elasticsearch");
var _catch_retryable_es_client_errors = require("./catch_retryable_es_client_errors");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/** @internal */

/**
 * Sets a write block in place for the given index. If the response includes
 * `acknowledged: true` all in-progress writes have drained and no further
 * writes to this index will be possible.
 *
 * The first time the write block is added to an index the response will
 * include `shards_acknowledged: true` but once the block is in place,
 * subsequent calls return `shards_acknowledged: false`
 */
const setWriteBlock = ({
  client,
  index
}) => () => {
  return client.indices.addBlock({
    index,
    block: 'write'
  }, {
    maxRetries: 0 /** handle retry ourselves for now */
  })
  // not typed yet
  .then(res => {
    return res.body.acknowledged === true ? Either.right('set_write_block_succeeded') : Either.left({
      type: 'retryable_es_client_error',
      message: 'set_write_block_failed'
    });
  }).catch(e => {
    if (e instanceof _elasticsearch.errors.ResponseError) {
      var _e$body, _e$body$error;
      if (((_e$body = e.body) === null || _e$body === void 0 ? void 0 : (_e$body$error = _e$body.error) === null || _e$body$error === void 0 ? void 0 : _e$body$error.type) === 'index_not_found_exception') {
        return Either.left({
          type: 'index_not_found_exception',
          index
        });
      }
    }
    throw e;
  }).catch(_catch_retryable_es_client_errors.catchRetryableEsClientErrors);
};
//
exports.setWriteBlock = setWriteBlock;