"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkForUnknownDocs = void 0;
var Either = _interopRequireWildcard(require("fp-ts/lib/Either"));
var _catch_retryable_es_client_errors = require("./catch_retryable_es_client_errors");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/** @internal */

/** @internal */

/** @internal */

const checkForUnknownDocs = ({
  client,
  indexName,
  unusedTypesQuery,
  knownTypes
}) => () => {
  const query = createUnknownDocQuery(unusedTypesQuery, knownTypes);
  return client.search({
    index: indexName,
    body: {
      query
    }
  }).then(response => {
    const {
      hits
    } = response.body.hits;
    return Either.right({
      unknownDocs: hits.map(hit => {
        var _hit$_source$type, _hit$_source;
        return {
          id: hit._id,
          type: (_hit$_source$type = (_hit$_source = hit._source) === null || _hit$_source === void 0 ? void 0 : _hit$_source.type) !== null && _hit$_source$type !== void 0 ? _hit$_source$type : 'unknown'
        };
      })
    });
  }).catch(_catch_retryable_es_client_errors.catchRetryableEsClientErrors);
};
exports.checkForUnknownDocs = checkForUnknownDocs;
const createUnknownDocQuery = (unusedTypesQuery, knownTypes) => {
  return {
    bool: {
      must: unusedTypesQuery,
      must_not: knownTypes.map(type => ({
        term: {
          type
        }
      }))
    }
  };
};