"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createListStream = createListStream;
var _stream = require("stream");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 *  Create a Readable stream that provides the items
 *  from a list as objects to subscribers
 *
 *  @param  {Array<any>} items - the list of items to provide
 *  @return {Readable}
 */
function createListStream(items = []) {
  const queue = Array.isArray(items) ? [...items] : [items];
  return new _stream.Readable({
    objectMode: true,
    read(size) {
      queue.splice(0, size).forEach(item => {
        this.push(item);
      });
      if (!queue.length) {
        this.push(null);
      }
    }
  });
}