/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import * as t from 'io-ts';
import { DefaultUpdateCommentsArray } from '../../common/default_update_comments_array';
import { exceptionListItemType } from '../../common/exception_list_item_type';
import { nonEmptyEntriesArray } from '../../common/non_empty_entries_array';
import { osTypeArrayOrUndefined } from '../../common/os_type';
import { tags } from '../../common/tags';
import { description } from '../../common/description';
import { name } from '../../common/name';
import { _version } from '../../common/underscore_version';
import { id } from '../../common/id';
import { meta } from '../../common/meta';
import { namespace_type } from '../../common/namespace_type';
export var updateExceptionListItemSchema = t.intersection([t.exact(t.type({
  description: description,
  entries: nonEmptyEntriesArray,
  name: name,
  type: exceptionListItemType
})), t.exact(t.partial({
  _version: _version,
  // defaults to undefined if not set during decode
  comments: DefaultUpdateCommentsArray,
  // defaults to empty array if not set during decode
  id: id,
  // defaults to undefined if not set during decode
  item_id: t.union([t.string, t.undefined]),
  meta: meta,
  // defaults to undefined if not set during decode
  namespace_type: namespace_type,
  // defaults to 'single' if not set during decode
  os_types: osTypeArrayOrUndefined,
  // defaults to empty array if not set during decode
  tags: tags // defaults to empty array if not set during decode
}))]);

// This type is used after a decode since some things are defaults after a decode.