/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import * as t from 'io-ts';
import { version } from '@kbn/securitysolution-io-ts-types';
import { id } from '../../common/id';
import { _version } from '../../common/underscore_version';
import { meta } from '../../common/meta';
import { name } from '../../common/name';
import { description } from '../../common/description';
export var patchListSchema = t.intersection([t.exact(t.type({
  id: id
})), t.exact(t.partial({
  _version: _version,
  // is undefined if not set during decode
  description: description,
  // is undefined if not set during decode
  meta: meta,
  // is undefined if not set during decode
  name: name,
  // is undefined if not set during decode
  version: version // is undefined if not set during decode
}))]);