/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import * as t from 'io-ts';
import { entriesExists } from '../entries_exist';
import { entriesList } from '../entries_list';
import { entriesMatch } from '../entry_match';
import { entriesMatchAny } from '../entry_match_any';
import { entriesMatchWildcard } from '../entry_match_wildcard';
import { entriesNested } from '../entry_nested';

// NOTE: Type nested is not included here to denote it's non-recursive nature.
// So a nested entry is really just a collection of `Entry` types.
export var entry = t.union([entriesMatch, entriesMatchAny, entriesList, entriesExists, entriesMatchWildcard]);
export var entriesArray = t.array(t.union([entriesMatch, entriesMatchAny, entriesList, entriesExists, entriesNested, entriesMatchWildcard]));
export var entriesArrayOrUndefined = t.union([entriesArray, t.undefined]);