"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.nonEmptyNestedEntriesArray = exports.nestedEntryItem = exports.nestedEntriesArray = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _entry_match = require("../entry_match");
var _entry_match_any = require("../entry_match_any");
var _entries_exist = require("../entries_exist");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const nestedEntryItem = exports.nestedEntryItem = t.union([_entry_match.entriesMatch, _entry_match_any.entriesMatchAny, _entries_exist.entriesExists]);
const nestedEntriesArray = exports.nestedEntriesArray = t.array(nestedEntryItem);
/**
 * Types the nonEmptyNestedEntriesArray as:
 *   - An array of entries of length 1 or greater
 *
 */
const nonEmptyNestedEntriesArray = exports.nonEmptyNestedEntriesArray = new t.Type('NonEmptyNestedEntriesArray', nestedEntriesArray.is, (input, context) => {
  if (Array.isArray(input) && input.length === 0) {
    return t.failure(input, context);
  } else {
    return nestedEntriesArray.validate(input, context);
  }
}, t.identity);