"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.nonEmptyEntriesArray = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _entries = require("../entries");
var _entries_list = require("../entries_list");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Types the nonEmptyEntriesArray as:
 *   - An array of entries of length 1 or greater
 *
 */
const nonEmptyEntriesArray = exports.nonEmptyEntriesArray = new t.Type('NonEmptyEntriesArray', _entries.entriesArray.is, (input, context) => {
  if (Array.isArray(input) && input.length === 0) {
    return t.failure(input, context);
  } else {
    if (Array.isArray(input) && input.some(entry => _entries_list.entriesList.is(entry)) && input.some(entry => !_entries_list.entriesList.is(entry))) {
      // fail when an exception item contains both a value list entry and a non-value list entry
      return t.failure(input, context, 'Cannot have entry of type list and other');
    }
    return _entries.entriesArray.validate(input, context);
  }
}, t.identity);